/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.satisfyu.meadow.Meadow;
import net.satisfyu.meadow.effects.CozyHomeEffect;
import net.satisfyu.meadow.util.MeadowIdentifier;

public class EffectRegistry {
    public static final DeferredRegister<MobEffect> STATUS_EFFECTS = DeferredRegister.create((String)"meadow", (ResourceKey)Registries.f_256929_);
    public static final Registrar<MobEffect> STATUS_EFFECTS_REGISTRAR = STATUS_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> COZY_HOME = EffectRegistry.registerEffect("cozy_home", CozyHomeEffect::new);

    public static void init() {
        Meadow.LOGGER.debug("Mob effects");
        STATUS_EFFECTS.register();
    }

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return STATUS_EFFECTS.register(name, effect);
        }
        return STATUS_EFFECTS_REGISTRAR.register((ResourceLocation)new MeadowIdentifier(name), effect);
    }
}

