/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.satisfyu.meadow.Meadow;
import net.satisfyu.meadow.client.screen.handler.CheeseFormGuiHandler;
import net.satisfyu.meadow.client.screen.handler.CookingCauldronGuiHandler;
import net.satisfyu.meadow.client.screen.handler.FondueGuiHandler;
import net.satisfyu.meadow.client.screen.handler.WoodcutterGuiHandler;

public class ScreenHandlerRegistry {
    public static final DeferredRegister<MenuType<?>> SCREEN_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registries.f_256798_);
    public static final RegistrySupplier<MenuType<WoodcutterGuiHandler>> WOODCUTTER_SCREEN_HANDLER = ScreenHandlerRegistry.create("woodcutter", () -> new MenuType(WoodcutterGuiHandler::new, FeatureFlags.f_244377_));
    public static final RegistrySupplier<MenuType<CookingCauldronGuiHandler>> COOKING_CAULDRON_SCREEN_HANDLER = ScreenHandlerRegistry.create("cooking_cauldron", () -> new MenuType(CookingCauldronGuiHandler::new, FeatureFlags.f_244377_));
    public static final RegistrySupplier<MenuType<CheeseFormGuiHandler>> CHEESE_FORM_SCREEN_HANDLER = ScreenHandlerRegistry.create("cheese_form", () -> new MenuType(CheeseFormGuiHandler::new, FeatureFlags.f_244377_));
    public static final RegistrySupplier<MenuType<FondueGuiHandler>> FONDUE_SCREEN_HANDLER = ScreenHandlerRegistry.create("fondue", () -> new MenuType(FondueGuiHandler::new, FeatureFlags.f_244377_));

    public static void init() {
        Meadow.LOGGER.debug("Registering Screens for meadow");
        SCREEN_TYPES.register();
    }

    private static <T extends MenuType<?>> RegistrySupplier<T> create(String name, Supplier<T> type) {
        return SCREEN_TYPES.register(name, type);
    }
}

