/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.satisfyu.meadow.world.MeadowSurfaceRules;
import terrablender.api.ParameterUtils;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class MeadowRegion
extends Region {
    public MeadowRegion(ResourceLocation name, int weight) {
        super(name, RegionType.OVERWORLD, weight);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addModifiedVanillaOverworldBiomes(mapper, builder -> {
            List meadowForestPoints = new ParameterUtils.ParameterPointListBuilder().temperature(new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f)}).humidity(new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.36f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f)}).continentalness(new ParameterUtils.Continentalness[]{ParameterUtils.Continentalness.FAR_INLAND}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.EROSION_1, ParameterUtils.Erosion.EROSION_2, ParameterUtils.Erosion.EROSION_3}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.SURFACE, ParameterUtils.Depth.FLOOR}).weirdness(new ParameterUtils.Weirdness[]{ParameterUtils.Weirdness.HIGH_SLICE_NORMAL_ASCENDING, ParameterUtils.Weirdness.PEAK_NORMAL, ParameterUtils.Weirdness.HIGH_SLICE_NORMAL_DESCENDING, ParameterUtils.Weirdness.MID_SLICE_NORMAL_DESCENDING, ParameterUtils.Weirdness.MID_SLICE_VARIANT_ASCENDING, ParameterUtils.Weirdness.HIGH_SLICE_VARIANT_ASCENDING, ParameterUtils.Weirdness.PEAK_VARIANT, ParameterUtils.Weirdness.HIGH_SLICE_VARIANT_DESCENDING, ParameterUtils.Weirdness.MID_SLICE_VARIANT_DESCENDING}).build();
            meadowForestPoints.forEach(point -> builder.replaceBiome(point, MeadowSurfaceRules.MEADOW_FOREST_KEY));
            List meadowClearingPoints = new ParameterUtils.ParameterPointListBuilder().temperature(new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f)}).humidity(new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f)}).continentalness(new ParameterUtils.Continentalness[]{ParameterUtils.Continentalness.FAR_INLAND}).erosion(new ParameterUtils.Erosion[]{ParameterUtils.Erosion.EROSION_1, ParameterUtils.Erosion.EROSION_2, ParameterUtils.Erosion.EROSION_3}).depth(new ParameterUtils.Depth[]{ParameterUtils.Depth.SURFACE, ParameterUtils.Depth.FLOOR}).weirdness(new ParameterUtils.Weirdness[]{ParameterUtils.Weirdness.HIGH_SLICE_NORMAL_ASCENDING, ParameterUtils.Weirdness.HIGH_SLICE_NORMAL_DESCENDING, ParameterUtils.Weirdness.MID_SLICE_NORMAL_DESCENDING, ParameterUtils.Weirdness.MID_SLICE_VARIANT_ASCENDING, ParameterUtils.Weirdness.HIGH_SLICE_VARIANT_ASCENDING, ParameterUtils.Weirdness.HIGH_SLICE_VARIANT_DESCENDING, ParameterUtils.Weirdness.MID_SLICE_VARIANT_DESCENDING}).build();
            meadowClearingPoints.forEach(point -> builder.replaceBiome(point, MeadowSurfaceRules.MEADOW_CLEARING_KEY));
        });
    }

    public static void loadTerrablender() {
        Regions.register((Region)new MeadowRegion(new ResourceLocation("meadow", "overworld"), 5));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"meadow", (SurfaceRules.RuleSource)MeadowSurfaceRules.makeRules());
    }
}

