/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.util;

import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfyu.meadow.registry.ObjectRegistry;

public interface WoodenCauldronBehavior
extends CauldronInteraction {
    public static final Map<Item, CauldronInteraction> EMPTY = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> WATER = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> POWDER_SNOW = CauldronInteraction.m_175617_();
    public static final CauldronInteraction FILL_WATER = (state, world, pos, player, hand, stack) -> WoodenCauldronBehavior.fillCauldron(world, pos, player, hand, stack, (BlockState)((Block)ObjectRegistry.WOODEN_WATER_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_11778_, Items.f_42446_);
    public static final CauldronInteraction FILL_POWDER_SNOW = (state, world, pos, player, hand, stack) -> WoodenCauldronBehavior.fillCauldron(world, pos, player, hand, stack, (BlockState)((Block)ObjectRegistry.WOODEN_POWDER_SNOW_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_144076_, Items.f_42446_);
    public static final CauldronInteraction FILL_WITH_WATER_W = (state, world, pos, player, hand, stack) -> WoodenCauldronBehavior.fillCauldron(world, pos, player, hand, stack, (BlockState)((Block)ObjectRegistry.WOODEN_WATER_CAULDRON.get()).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_11778_, (Item)ObjectRegistry.WOODEN_BUCKET.get());

    public InteractionResult m_175710_(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, ItemStack var6);

    public static void bootStrap() {
        WoodenCauldronBehavior.registerCauldronBehavior();
        WoodenCauldronBehavior.addDefaultInteractions(EMPTY);
        EMPTY.put(Items.f_42589_, (state, world, pos, player, hand, stack) -> {
            if (PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43599_) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                world.m_46597_(pos, ((Block)ObjectRegistry.WOODEN_WATER_CAULDRON.get()).m_49966_());
                world.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_(null, GameEvent.f_157769_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        });
        WoodenCauldronBehavior.addDefaultInteractions(WATER);
        WATER.put(Items.f_42446_, (state2, world, pos, player, hand, stack) -> WoodenCauldronBehavior.fillBucket(state2, world, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_42447_), state -> (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
        WATER.put((Item)ObjectRegistry.WOODEN_BUCKET.get(), (state2, world, pos, player, hand, stack) -> WoodenCauldronBehavior.fillBucket(state2, world, pos, player, hand, stack, new ItemStack((ItemLike)ObjectRegistry.WOODEN_WATER_BUCKET.get()), state -> (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_11781_));
        WATER.put(Items.f_42590_, (state, world, pos, player, hand, stack) -> {
            if (!world.f_46443_) {
                Item item = stack.m_41720_();
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_(null, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        });
        WATER.put(Items.f_42589_, (state, world, pos, player, hand, stack) -> {
            if ((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3 || PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43599_) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                world.m_46597_(pos, (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                world.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_142346_(null, GameEvent.f_157769_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        });
        WATER.put(Items.f_42463_, f_175615_);
        WATER.put(Items.f_42462_, f_175615_);
        WATER.put(Items.f_42408_, f_175615_);
        WATER.put(Items.f_42407_, f_175615_);
        WATER.put(Items.f_42654_, f_175615_);
        WATER.put(Items.f_42660_, f_175614_);
        WATER.put(Items.f_42667_, f_175614_);
        WATER.put(Items.f_42728_, f_175614_);
        WATER.put(Items.f_42671_, f_175614_);
        WATER.put(Items.f_42672_, f_175614_);
        WATER.put(Items.f_42669_, f_175614_);
        WATER.put(Items.f_42673_, f_175614_);
        WATER.put(Items.f_42663_, f_175614_);
        WATER.put(Items.f_42668_, f_175614_);
        WATER.put(Items.f_42665_, f_175614_);
        WATER.put(Items.f_42662_, f_175614_);
        WATER.put(Items.f_42661_, f_175614_);
        WATER.put(Items.f_42666_, f_175614_);
        WATER.put(Items.f_42670_, f_175614_);
        WATER.put(Items.f_42727_, f_175614_);
        WATER.put(Items.f_42664_, f_175614_);
        WATER.put(Items.f_42266_, f_175613_);
        WATER.put(Items.f_42273_, f_175613_);
        WATER.put(Items.f_42229_, f_175613_);
        WATER.put(Items.f_42225_, f_175613_);
        WATER.put(Items.f_42226_, f_175613_);
        WATER.put(Items.f_42275_, f_175613_);
        WATER.put(Items.f_42227_, f_175613_);
        WATER.put(Items.f_42269_, f_175613_);
        WATER.put(Items.f_42274_, f_175613_);
        WATER.put(Items.f_42271_, f_175613_);
        WATER.put(Items.f_42268_, f_175613_);
        WATER.put(Items.f_42267_, f_175613_);
        WATER.put(Items.f_42272_, f_175613_);
        WATER.put(Items.f_42224_, f_175613_);
        WATER.put(Items.f_42228_, f_175613_);
        WATER.put(Items.f_42270_, f_175613_);
        POWDER_SNOW.put(Items.f_42446_, (state2, world, pos, player, hand, stack) -> WoodenCauldronBehavior.fillBucket(state2, world, pos, player, hand, stack, new ItemStack((ItemLike)Items.f_151055_), state -> (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, SoundEvents.f_144089_));
        WoodenCauldronBehavior.addDefaultInteractions(POWDER_SNOW);
    }

    public static void addDefaultInteractions(Map<Item, CauldronInteraction> behavior) {
        behavior.put(Items.f_42447_, FILL_WATER);
        behavior.put((Item)ObjectRegistry.WOODEN_WATER_BUCKET.get(), FILL_WITH_WATER_W);
        behavior.put(Items.f_151055_, FILL_POWDER_SNOW);
    }

    public static InteractionResult fillBucket(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, ItemStack output, Predicate<BlockState> predicate, SoundEvent soundEvent) {
        if (!predicate.test(state)) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)output));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            world.m_46597_(pos, ((Block)ObjectRegistry.WOODEN_CAULDRON.get()).m_49966_());
            world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_142346_(null, GameEvent.f_157816_, pos);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public static InteractionResult fillCauldron(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack, BlockState state, SoundEvent soundEvent, Item returnItem) {
        if (!world.f_46443_) {
            Item item = stack.m_41720_();
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)returnItem)));
            player.m_36220_(Stats.f_12943_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            world.m_46597_(pos, state);
            world.m_5594_(null, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_142346_(null, GameEvent.f_157769_, pos);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public static void registerCauldronBehavior() {
        CauldronInteraction.f_175607_.put((Item)ObjectRegistry.WOODEN_BUCKET.get(), (state2, world, pos, player, hand, stack) -> CauldronInteraction.m_175635_((BlockState)state2, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ObjectRegistry.WOODEN_WATER_BUCKET.get()), state -> (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, (SoundEvent)SoundEvents.f_11781_));
        WoodenCauldronBehavior.registerBucketBehaviorForNormalCauldron(CauldronInteraction.f_175606_);
    }

    public static void registerBucketBehaviorForNormalCauldron(Map<Item, CauldronInteraction> behavior) {
        CauldronInteraction fillWithWater = (state, world, pos, player, hand, stack) -> WoodenCauldronBehavior.fillCauldron(world, pos, player, hand, stack, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_11778_, (Item)ObjectRegistry.WOODEN_BUCKET.get());
        CauldronInteraction fillWithPowderSnow = (state, world, pos, player, hand, stack) -> WoodenCauldronBehavior.fillCauldron(world, pos, player, hand, stack, (BlockState)Blocks.f_152478_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), SoundEvents.f_144076_, (Item)ObjectRegistry.WOODEN_BUCKET.get());
        behavior.put((Item)ObjectRegistry.WOODEN_WATER_BUCKET.get(), fillWithWater);
    }
}

