/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.world;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.satisfyu.meadow.registry.ObjectRegistry;

public class MeadowSurfaceRules {
    private static final ResourceKey<NormalNoise.NoiseParameters> SURFACE = MeadowSurfaceRules.register("surface");
    private static final ResourceKey<NormalNoise.NoiseParameters> DIRT = MeadowSurfaceRules.register("dirt");
    private static final ResourceKey<NormalNoise.NoiseParameters> CRACKS = MeadowSurfaceRules.register("cracks");
    private static final SurfaceRules.RuleSource LIMESTONE = MeadowSurfaceRules.makeStateRule((Block)ObjectRegistry.LIMESTONE.get());
    private static final SurfaceRules.RuleSource COBBLED_LIMESTONE = MeadowSurfaceRules.makeStateRule((Block)ObjectRegistry.COBBLED_LIMESTONE.get());
    private static final SurfaceRules.RuleSource PODZOL = MeadowSurfaceRules.makeStateRule(Blocks.f_50599_);
    private static final SurfaceRules.RuleSource COARSE_DIRT = MeadowSurfaceRules.makeStateRule(Blocks.f_50546_);
    private static final SurfaceRules.RuleSource DIRT_BLOCK = MeadowSurfaceRules.makeStateRule(Blocks.f_50493_);
    public static final ResourceKey<Biome> MEADOW_CLEARING_KEY = MeadowSurfaceRules.createBiomeKey("meadow_clearing");
    public static final ResourceKey<Biome> MEADOW_FOREST_KEY = MeadowSurfaceRules.createBiomeKey("meadow_forest");

    private static ResourceKey<Biome> createBiomeKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("meadow", name));
    }

    public static SurfaceRules.RuleSource makeRules() {
        SurfaceRules.ConditionSource isAtOrAboveWaterLevel = SurfaceRules.m_189382_((int)-1, (int)0);
        SurfaceRules.RuleSource podzol = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)PODZOL), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)DIRT_BLOCK)});
        SurfaceRules.RuleSource clearing = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(CRACKS, (double)-0.15, (double)0.15), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(SURFACE, (double)Double.parseDouble("-1e+308"), (double)0.1), (SurfaceRules.RuleSource)COARSE_DIRT), COBBLED_LIMESTONE})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(SURFACE, (double)0.0, (double)Double.parseDouble("1.7976931348623157e+308")), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(DIRT, (double)0.3, (double)Double.parseDouble("1e+308")), (SurfaceRules.RuleSource)COARSE_DIRT)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(SURFACE, (double)0.2, (double)Double.parseDouble("1.7976931348623157e+308")), (SurfaceRules.RuleSource)LIMESTONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(SURFACE, (double)0.0, (double)Double.parseDouble("1.7976931348623157e+308")), (SurfaceRules.RuleSource)COARSE_DIRT)});
        SurfaceRules.RuleSource forest = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(CRACKS, (double)-0.15, (double)0.15), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(SURFACE, (double)Double.parseDouble("-1e+308"), (double)0.1), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)COARSE_DIRT)), podzol})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(SURFACE, (double)0.0, (double)Double.parseDouble("1.7976931348623157e+308")), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(DIRT, (double)0.3, (double)Double.parseDouble("1e+308")), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)COARSE_DIRT))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(SURFACE, (double)0.2, (double)Double.parseDouble("1.7976931348623157e+308")), (SurfaceRules.RuleSource)podzol), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_(SURFACE, (double)0.0, (double)Double.parseDouble("1.7976931348623157e+308")), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)COARSE_DIRT))});
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MEADOW_CLEARING_KEY}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189381_(), (SurfaceRules.RuleSource)LIMESTONE), clearing})))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{MEADOW_FOREST_KEY}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189381_(), (SurfaceRules.RuleSource)LIMESTONE), forest})))});
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.m_189390_((BlockState)block.m_49966_());
    }

    private static ResourceKey<NormalNoise.NoiseParameters> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256865_, (ResourceLocation)new ResourceLocation("meadow", name));
    }
}

