/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.cristelknight.doapi.common.block.FacingBlock;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.config.VineryConfig;
import satisfyu.vinery.util.WineYears;

public class CalendarBlock
extends FacingBlock {
    private static final Map<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0)));

    public CalendarBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return CalendarBlock.getBoundingShape(state);
    }

    public static VoxelShape getBoundingShape(BlockState state) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = world.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)world, blockPos, direction);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)f_54117_, (Comparable)direction.m_122424_())).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.m_122424_() == state.m_61143_((Property)f_54117_) && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.vinery.decoration.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        if (world instanceof Level) {
            Level level = (Level)world;
            long hour = level.m_46468_() / 1000L % 24L;
            long day = level.m_46468_() / 24000L % (long)((VineryConfig)VineryConfig.DEFAULT.getConfig()).yearLengthInDays();
            tooltip.add((Component)Component.m_237113_((String)(hour + "h / " + day + "d / " + WineYears.getYear(level) + "y")).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

