/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.registry.VinerySoundEvents;
import satisfyu.vinery.util.GeneralUtil;

public class KitchenSinkBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.1875, (double)0.1859375, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.75, (double)0.1875, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    private static final Supplier<VoxelShape> voxelShapeWithFaucetSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3984375, (double)1.171875, (double)0.84375, (double)0.4296875, (double)1.234375, (double)0.90625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4296875, (double)1.375, (double)0.625, (double)0.5546875, (double)1.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4296875, (double)1.3125, (double)0.5, (double)0.5546875, (double)1.5, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4296875, (double)1.0625, (double)0.8125, (double)0.5546875, (double)1.375, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3828125, (double)1.25, (double)0.453125, (double)0.6015625, (double)1.3125, (double)0.671875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3671875, (double)1.0, (double)0.75, (double)0.6171875, (double)1.0625, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3671875, (double)1.125, (double)0.78125, (double)0.3984375, (double)1.3125, (double)0.96875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)1.0, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.75, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.1875, (double)0.1859375, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.8125, (double)0.75, (double)0.1875, (double)1.0, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE_WITH_FAUCET = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeWithFaucetSupplier.get()));
        }
    });

    public KitchenSinkBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (itemStack.m_41619_() && !((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
            if (!world.m_5776_()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(true)), 3);
                world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)VinerySoundEvents.BLOCK_FAUCET.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12540_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if ((item == Items.f_42447_ || PotionUtils.m_43579_((ItemStack)itemStack).equals(Potions.f_43599_)) && !((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
            ItemStack itemReturn = item == Items.f_42447_ ? new ItemStack((ItemLike)Items.f_42446_) : new ItemStack((ItemLike)Items.f_42590_);
            return GeneralUtil.fillBucket(world, pos, player, hand, itemStack, itemReturn, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(true)), SoundEvents.f_11778_);
        }
        if ((item == Items.f_42446_ || item == Items.f_42590_) && ((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
            ItemStack itemReturn = item == Items.f_42446_ ? new ItemStack((ItemLike)Items.f_42447_) : PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
            return GeneralUtil.emptyBucket(world, pos, player, hand, itemStack, itemReturn, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)), SoundEvents.f_11781_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE_WITH_FAUCET.get(state.m_61143_((Property)FACING));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FILLED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.vinery.deprecated.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

