/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.stem;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import satisfyu.vinery.util.GrapevineType;

public abstract class StemBlock
extends Block
implements BonemealableBlock {
    public static final EnumProperty<GrapevineType> GRAPE = EnumProperty.m_61587_((String)"grape", GrapevineType.class);
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;

    public StemBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(GRAPE, (Comparable)((Object)GrapevineType.NONE))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void dropGrapes(Level world, BlockState state, BlockPos pos) {
        int x = 1 + world.f_46441_.m_188503_(this.isMature(state) ? 2 : 1);
        int bonus = this.isMature(state) ? 2 : 1;
        Item grape = ((GrapevineType)((Object)state.m_61143_(GRAPE))).getFruit();
        StemBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)grape, x + bonus));
        world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
    }

    public void dropGrapeSeeds(Level world, BlockState state, BlockPos pos) {
        Item grape = ((GrapevineType)((Object)state.m_61143_(GRAPE))).getSeeds();
        StemBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)grape));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age > 3) {
            this.dropGrapes(world, state, pos);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if ((Integer)state.m_61143_((Property)AGE) > 2) {
            this.dropGrapes(world, state, pos);
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean hasTrunk(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60734_() == this;
    }

    private void boneMealGrow(Level world, BlockState state, BlockPos pos) {
        int age = (Integer)state.m_61143_((Property)AGE) + Mth.m_216271_((RandomSource)world.m_213780_(), (int)1, (int)2);
        int j = 4;
        if (age > 4) {
            age = j;
        }
        world.m_7731_(pos, this.withAge(state, age, (GrapevineType)((Object)state.m_61143_(GRAPE))), 2);
    }

    public BlockState withAge(BlockState state, int age, GrapevineType type) {
        return (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age))).m_61124_(GRAPE, (Comparable)((Object)type));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, GRAPE});
    }

    public boolean isMature(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) >= 4;
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState state, boolean bl) {
        return !this.isMature(state) && levelReader.m_8055_(blockPos.m_7495_()).m_60734_() == this && (Integer)state.m_61143_((Property)AGE) > 0;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        this.boneMealGrow((Level)world, state, pos);
    }
}

