/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.client.gui.config;

import de.cristelknight.doapi.DoApiRL;
import de.cristelknight.doapi.config.cloth.CCUtil;
import de.cristelknight.doapi.config.cloth.LinkEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import satisfyu.vinery.config.VineryConfig;

public class ClothConfigScreen {
    private static Screen lastScreen;

    public static Screen create(Screen parent) {
        lastScreen = parent;
        VineryConfig config = (VineryConfig)VineryConfig.DEFAULT.getConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setDefaultBackgroundTexture(new ResourceLocation("textures/block/dirt.png")).setTitle((Component)Component.m_237115_((String)"vinery.config.title").m_130940_(ChatFormatting.BOLD));
        ConfigEntries entries = new ConfigEntries(builder.entryBuilder(), config, builder.getOrCreateCategory(CCUtil.categoryName((String)"main", (String)"vinery")));
        builder.setSavingRunnable(() -> {
            VineryConfig.DEFAULT.setInstance(entries.createConfig());
            VineryConfig.DEFAULT.getConfig(true, true);
        });
        return builder.build();
    }

    private static Component entryName(String id) {
        return CCUtil.entryName((String)id, (String)"vinery");
    }

    public static Component translatableText(String id) {
        return CCUtil.translatableText((String)id, (String)"vinery");
    }

    public static void linkButtons(String modid, ConfigCategory category, ConfigEntryBuilder builder, String dcLink, String cfLink, Screen lastScreen) {
        if (lastScreen == null) {
            lastScreen = Minecraft.m_91087_().f_91080_;
        }
        TextListEntry tle = builder.startTextDescription((Component)Component.m_237113_((String)" ")).build();
        category.addEntry((AbstractConfigListEntry)tle);
        Screen finalLastScreen = lastScreen;
        category.addEntry((AbstractConfigListEntry)new LinkEntry(CCUtil.entryName((String)modid, (String)"dc"), buttonWidget -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.m_137581_().m_137646_(dcLink);
            }
            Minecraft.m_91087_().m_91152_(ClothConfigScreen.create(finalLastScreen));
        }, dcLink, true)), (ResourceLocation)new DoApiRL("textures/gui/dc.png"), 3));
        category.addEntry((AbstractConfigListEntry)tle);
        category.addEntry((AbstractConfigListEntry)new LinkEntry(CCUtil.entryName((String)modid, (String)"h"), buttonWidget -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.m_137581_().m_137646_(cfLink);
            }
            Minecraft.m_91087_().m_91152_(ClothConfigScreen.create(finalLastScreen));
        }, cfLink, true)), (ResourceLocation)new DoApiRL("textures/gui/cf.png"), 10));
    }

    private static class ConfigEntries {
        private final ConfigEntryBuilder builder;
        private final ConfigCategory category;
        private final BooleanListEntry enableWineMakerSetBonus;
        private final IntegerListEntry wineTraderChance;
        private final IntegerListEntry yearLengthInDays;

        public ConfigEntries(ConfigEntryBuilder builder, VineryConfig config, ConfigCategory category) {
            this.builder = builder;
            this.category = category;
            this.enableWineMakerSetBonus = this.createBooleanField("enableWineMakerSetBonus", config.enableWineMakerSetBonus(), VineryConfig.DEFAULT.enableWineMakerSetBonus());
            this.wineTraderChance = this.createIntField("wineTraderChance", config.wineTraderChance(), VineryConfig.DEFAULT.wineTraderChance());
            this.yearLengthInDays = this.createIntField("yearLengthInDays", config.yearLengthInDays(), VineryConfig.DEFAULT.yearLengthInDays());
            ClothConfigScreen.linkButtons("vinery", category, builder, "https://discord.gg/Vqu6wYZwdZ", "https://www.curseforge.com/minecraft/mc-mods/lets-do-wine", lastScreen);
        }

        public VineryConfig createConfig() {
            return new VineryConfig(this.wineTraderChance.getValue(), this.yearLengthInDays.getValue(), this.enableWineMakerSetBonus.getValue());
        }

        public BooleanListEntry createBooleanField(String id, boolean value, boolean defaultValue) {
            BooleanListEntry e = CCUtil.createBooleanField((String)"vinery", (String)id, (boolean)value, (boolean)defaultValue, (ConfigEntryBuilder)this.builder);
            this.category.addEntry((AbstractConfigListEntry)e);
            return e;
        }

        public IntegerListEntry createIntField(String id, int value, int defaultValue) {
            IntegerListEntry e = CCUtil.createIntField((String)"vinery", (String)id, (int)value, (int)defaultValue, (ConfigEntryBuilder)this.builder);
            this.category.addEntry((AbstractConfigListEntry)e);
            return e;
        }
    }
}

