/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.client.recipebook;

import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeBookWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import satisfyu.vinery.recipe.FermentationBarrelRecipe;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.registry.VineryRecipeTypes;

@OnlyIn(value=Dist.CLIENT)
public class FermentationPotRecipeBook
extends PrivateRecipeBookWidget {
    private static final Component TOGGLE_FERMENTABLE_TEXT = Component.m_237115_((String)"gui.vinery.recipebook.toggleRecipes.fermentable");

    public void showGhostRecipe(Recipe<?> recipe, List<Slot> slots, RegistryAccess registryAccess) {
        this.ghostSlots.addSlot(recipe.m_8043_(registryAccess), slots.get((int)5).f_40220_, slots.get((int)5).f_40221_);
        this.ghostSlots.addSlot(((Item)ObjectRegistry.WINE_BOTTLE.get()).m_5456_().m_7968_(), slots.get((int)0).f_40220_, slots.get((int)0).f_40221_);
        int j = 1;
        for (Ingredient ingredient : recipe.m_7527_()) {
            ItemStack[] inputStacks = ingredient.m_43908_();
            ItemStack inputStack = inputStacks[RandomSource.m_216327_().m_216339_(0, inputStacks.length)];
            this.ghostSlots.addSlot(inputStack, slots.get((int)j).f_40220_, slots.get((int)j++).f_40221_);
        }
    }

    protected RecipeType<? extends Recipe<Container>> getRecipeType() {
        return (RecipeType)VineryRecipeTypes.FERMENTATION_BARREL_RECIPE_TYPE.get();
    }

    public void insertRecipe(Recipe<?> recipe) {
        if (recipe instanceof FermentationBarrelRecipe) {
            int slotIndex = 0;
            for (Slot slot : this.screenHandler.f_38839_) {
                if (slot.m_7993_().m_41720_() == ((Item)ObjectRegistry.WINE_BOTTLE.get()).m_5456_()) {
                    Minecraft.m_91087_().f_91072_.m_171799_(this.screenHandler.f_38840_, slotIndex, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                    Minecraft.m_91087_().f_91072_.m_171799_(this.screenHandler.f_38840_, 0, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                    break;
                }
                ++slotIndex;
            }
        }
        int usedInputSlots = 1;
        block1: for (Ingredient ingredient : recipe.m_7527_()) {
            int slotIndex = 0;
            for (Slot slot : this.screenHandler.f_38839_) {
                ItemStack itemStack = slot.m_7993_();
                if (ingredient.test(itemStack) && usedInputSlots < 5) {
                    Minecraft.m_91087_().f_91072_.m_171799_(this.screenHandler.f_38840_, slotIndex, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                    Minecraft.m_91087_().f_91072_.m_171799_(this.screenHandler.f_38840_, usedInputSlots, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                    ++usedInputSlots;
                    continue block1;
                }
                ++slotIndex;
            }
        }
    }

    protected Component getToggleCraftableButtonText() {
        return TOGGLE_FERMENTABLE_TEXT;
    }

    public void m_93692_(boolean bl) {
    }

    public boolean m_93696_() {
        return false;
    }
}

