/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.compat.jei;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import satisfyu.vinery.VineryIdentifier;
import satisfyu.vinery.client.gui.handler.ApplePressGuiHandler;
import satisfyu.vinery.compat.jei.category.ApplePressCategory;
import satisfyu.vinery.compat.jei.category.FermentationBarrelCategory;
import satisfyu.vinery.compat.jei.transfer.FermentationTransferInfo;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.registry.VineryRecipeTypes;
import satisfyu.vinery.registry.VineryScreenHandlerTypes;

@JeiPlugin
public class VineryJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FermentationBarrelCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ApplePressCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_7465_();
        List fermentationBarrelRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)VineryRecipeTypes.FERMENTATION_BARREL_RECIPE_TYPE.get());
        registration.addRecipes(FermentationBarrelCategory.FERMENTATION_BARREL, fermentationBarrelRecipes);
        List applePressRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)VineryRecipeTypes.APPLE_PRESS_RECIPE_TYPE.get());
        registration.addRecipes(ApplePressCategory.APPLE_PRESS, applePressRecipes);
    }

    public ResourceLocation getPluginUid() {
        return new VineryIdentifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ApplePressGuiHandler.class, (MenuType)VineryScreenHandlerTypes.APPLE_PRESS_GUI_HANDLER.get(), ApplePressCategory.APPLE_PRESS, 0, 1, 2, 36);
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new FermentationTransferInfo());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)ObjectRegistry.FERMENTATION_BARREL.get()).m_5456_().m_7968_(), new RecipeType[]{FermentationBarrelCategory.FERMENTATION_BARREL});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.APPLE_PRESS.get()).m_5456_().m_7968_(), new RecipeType[]{ApplePressCategory.APPLE_PRESS});
    }

    public static void addSlot(IRecipeLayoutBuilder builder, int x, int y, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients(ingredient);
    }
}

