/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.doapi.config.jankson.config.CommentedConfig;
import java.util.HashMap;
import net.minecraft.Util;

public record VineryConfig(int wineTraderChance, int yearLengthInDays, boolean enableWineMakerSetBonus) implements CommentedConfig<VineryConfig>
{
    private static VineryConfig INSTANCE = null;
    public static final VineryConfig DEFAULT = new VineryConfig(50, 16, true);
    public static final Codec<VineryConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.intRange((int)0, (int)100).fieldOf("wine_trader_chance").orElse((Object)VineryConfig.DEFAULT.wineTraderChance).forGetter(c -> c.wineTraderChance), (App)Codec.intRange((int)1, (int)100).fieldOf("year_length_in_days").orElse((Object)VineryConfig.DEFAULT.yearLengthInDays).forGetter(c -> c.yearLengthInDays), (App)Codec.BOOL.fieldOf("enable_wine_maker_set_bonus").orElse((Object)VineryConfig.DEFAULT.enableWineMakerSetBonus).forGetter(c -> c.enableWineMakerSetBonus)).apply((Applicative)builder, VineryConfig::new));

    public HashMap<String, String> getComments() {
        return (HashMap)Util.m_137469_(new HashMap(), map -> {
            map.put("wine_trader_chance", "How many % of the normal wandering traders should be an wandering wine trader?");
            map.put("year_length_in_days", "Length of a year (in days).");
            map.put("enable_wine_maker_set_bonus", "Whether or not the wine maker armor should give a set bonus, which makes your bone meal infinite.");
        });
    }

    public String getHeader() {
        return "Vinery Config\n\n\n===========\nDiscord: https://discord.gg/Vqu6wYZwdZ\nCurseForge: https://www.curseforge.com/minecraft/mc-mods/lets-do-wine\nModrinth: https://modrinth.com/mod/vinery";
    }

    public String getSubPath() {
        return "vinery/config";
    }

    public VineryConfig getInstance() {
        return INSTANCE;
    }

    public VineryConfig getDefault() {
        return DEFAULT;
    }

    public Codec<VineryConfig> getCodec() {
        return CODEC;
    }

    public boolean isSorted() {
        return false;
    }

    public void setInstance(VineryConfig instance) {
        INSTANCE = instance;
    }
}

