/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import satisfyu.vinery.block.grape.GrapeBush;
import satisfyu.vinery.util.GrapevineType;

@Mixin(value={Fox.FoxEatBerriesGoal.class})
public abstract class FoxEntityEatSweetBerriesGoalMixin
extends MoveToBlockGoal {
    @Final
    @Shadow
    Fox f_28672_;

    public FoxEntityEatSweetBerriesGoalMixin(PathfinderMob mob, double speed, int range) {
        super(mob, speed, range);
    }

    @Inject(method={"isValidTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void isTargetPos(LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof GrapeBush) {
            cir.setReturnValue((Object)((Integer)state.m_61143_((Property)GrapeBush.AGE) >= 2 ? 1 : 0));
        }
    }

    @Inject(method={"onReachedTarget"}, at={@At(value="TAIL")})
    private void eatGrapes(CallbackInfo ci) {
        BlockState state = this.f_28672_.m_9236_().m_8055_(this.f_25602_);
        Block block = state.m_60734_();
        if (block instanceof GrapeBush) {
            GrapeBush bush = (GrapeBush)block;
            this.pickGrapes(state, bush.getType());
        }
    }

    private void pickGrapes(BlockState state, GrapevineType type) {
        int age = (Integer)state.m_61143_((Property)GrapeBush.AGE);
        state.m_61124_((Property)GrapeBush.AGE, (Comparable)Integer.valueOf(1));
        int j = 1 + this.f_28672_.m_9236_().f_46441_.m_188503_(2) + (age == 3 ? 1 : 0);
        ItemStack itemStack = this.f_28672_.m_6844_(EquipmentSlot.MAINHAND);
        ItemStack grape = FoxEntityEatSweetBerriesGoalMixin.getGrapeFor(type);
        if (itemStack.m_41619_()) {
            this.f_28672_.m_8061_(EquipmentSlot.MAINHAND, grape);
            --j;
        }
        if (j > 0) {
            Block.m_49840_((Level)this.f_28672_.m_9236_(), (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)grape.m_41720_(), j));
        }
        this.f_28672_.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
        this.f_28672_.m_9236_().m_7731_(this.f_25602_, (BlockState)state.m_61124_((Property)GrapeBush.AGE, (Comparable)Integer.valueOf(1)), 2);
    }

    private static ItemStack getGrapeFor(GrapevineType type) {
        return type.getFruit().m_7968_();
    }
}

