/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.mixin;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import satisfyu.vinery.registry.VineryEffects;
import satisfyu.vinery.util.GeneralUtil;
import satisfyu.vinery.util.VineryFoodComponent;
import satisfyu.vinery.util.WineYears;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Final
    @Shadow
    private final Map<MobEffect, MobEffectInstance> f_20945_ = Maps.newHashMap();

    protected LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    public boolean hasStatusEffect(MobEffect effect) {
        return this.f_20945_.containsKey(effect);
    }

    @Inject(method={"addEatEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyFoodEffects(ItemStack stack, Level world, LivingEntity targetEntity, CallbackInfo ci) {
        if (stack.m_41614_() && stack.m_41720_().m_41473_() instanceof VineryFoodComponent) {
            ci.cancel();
            Item item = stack.m_41720_();
            if (item.m_41472_()) {
                List list = item.m_41473_().m_38749_();
                for (Pair pair : list) {
                    if (world.f_46443_ || pair.getFirst() == null || !(world.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    MobEffectInstance statusEffectInstance = new MobEffectInstance((MobEffectInstance)pair.getFirst());
                    statusEffectInstance.f_19504_ = WineYears.getEffectLevel(stack, world);
                    if (statusEffectInstance.m_19544_().equals(MobEffects.f_19601_) || statusEffectInstance.m_19544_().equals(MobEffects.f_19602_)) {
                        statusEffectInstance.f_19503_ = 1;
                    }
                    targetEntity.m_7292_(statusEffectInstance);
                }
            }
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="TAIL")}, cancellable=true)
    private void canWalkOnWater(FluidState state, CallbackInfoReturnable<Boolean> cir) {
        if (!(state.m_76152_() != Fluids.f_76193_ || this.m_5842_() || this.m_6069_() || this.m_6067_())) {
            cir.setReturnValue((Object)this.hasStatusEffect((MobEffect)VineryEffects.IMPROVED_SPEED.get()));
        }
    }

    @Inject(method={"setLastHurtMob"}, at={@At(value="HEAD")})
    private void setTargetOnFire(Entity target, CallbackInfo ci) {
        if (target instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)target;
            if (this.hasStatusEffect((MobEffect)VineryEffects.IMPROVED_FIRE_RESISTANCE.get())) {
                targetEntity.m_20254_(5);
            }
        }
    }

    @Redirect(method={"calculateFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEffect(Lnet/minecraft/world/effect/MobEffect;)Lnet/minecraft/world/effect/MobEffectInstance;"))
    public MobEffectInstance improvedJumpBoostFall(LivingEntity livingEntity, MobEffect effect) {
        return livingEntity.m_21023_((MobEffect)VineryEffects.IMPROVED_JUMP_BOOST.get()) ? livingEntity.m_21124_((MobEffect)VineryEffects.IMPROVED_JUMP_BOOST.get()) : livingEntity.m_21124_(MobEffects.f_19603_);
    }

    @Inject(method={"getJumpBoostPower"}, at={@At(value="HEAD")}, cancellable=true)
    private void improvedJumpBoost(CallbackInfoReturnable<Float> cir) {
        if (this.hasStatusEffect((MobEffect)VineryEffects.IMPROVED_JUMP_BOOST.get())) {
            cir.setReturnValue((Object)Float.valueOf(0.1f * (float)(this.f_20945_.get(VineryEffects.IMPROVED_JUMP_BOOST.get()).m_19564_() + 1)));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasImprovedFireResistance(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (GeneralUtil.isFire(source) && this.hasStatusEffect((MobEffect)VineryEffects.IMPROVED_FIRE_RESISTANCE.get())) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal=1), ordinal=0)
    public float applyWaterCreatureSwimSpeedBoost(float j) {
        LivingEntity entity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof LivingEntity && (entity = (LivingEntity)livingEntityMixin).m_21023_((MobEffect)VineryEffects.IMPROVED_WATER_BREATHING.get())) {
            return 0.96f;
        }
        return j;
    }

    @Redirect(method={"updateInvisibilityStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z"))
    public boolean improvedNightVision(LivingEntity livingEntity, MobEffect effect) {
        return livingEntity.m_21023_(MobEffects.f_19609_) || livingEntity.m_21023_((MobEffect)VineryEffects.IMPROVED_NIGHT_VISION.get());
    }
}

