/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import satisfyu.vinery.Vinery;
import satisfyu.vinery.VineryIdentifier;
import satisfyu.vinery.effect.CreeperEffect;
import satisfyu.vinery.effect.ExperienceEffect;
import satisfyu.vinery.effect.ImprovedAbsorbtion;
import satisfyu.vinery.effect.ImprovedEffect;
import satisfyu.vinery.effect.ImprovedInstantHealth;
import satisfyu.vinery.effect.ImprovedRegeneration;
import satisfyu.vinery.effect.JellieEffect;
import satisfyu.vinery.effect.MagnetEffect;
import satisfyu.vinery.effect.TeleportEffect;
import satisfyu.vinery.effect.TrippyEffect;

public class VineryEffects {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> TRIPPY;
    public static final RegistrySupplier<MobEffect> JELLIE;
    public static final RegistrySupplier<MobEffect> MAGNET;
    public static final RegistrySupplier<MobEffect> TELEPORT;
    public static final RegistrySupplier<MobEffect> IMPROVED_SPEED;
    public static final RegistrySupplier<MobEffect> IMPROVED_ABSORBTION;
    public static final RegistrySupplier<MobEffect> IMPROVED_JUMP_BOOST;
    public static final RegistrySupplier<MobEffect> IMPROVED_STRENGTH;
    public static final RegistrySupplier<MobEffect> IMPROVED_INSTANT_HEALTH;
    public static final RegistrySupplier<MobEffect> IMPROVED_REGENERATION;
    public static final RegistrySupplier<MobEffect> IMPROVED_FIRE_RESISTANCE;
    public static final RegistrySupplier<MobEffect> IMPROVED_WATER_BREATHING;
    public static final RegistrySupplier<MobEffect> IMPROVED_NIGHT_VISION;
    public static final RegistrySupplier<MobEffect> IMPROVED_HASTE;
    public static final RegistrySupplier<MobEffect> CREEPER_EFFECT;
    public static final RegistrySupplier<MobEffect> EXPERIENCE_EFFECT;

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new VineryIdentifier(name), effect);
    }

    public static void init() {
        Vinery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        EXPERIENCE_EFFECT = VineryEffects.registerEffect("experience_effect", ExperienceEffect::new);
        TRIPPY = VineryEffects.registerEffect("trippy", TrippyEffect::new);
        JELLIE = VineryEffects.registerEffect("jellie", JellieEffect::new);
        MAGNET = VineryEffects.registerEffect("magnet", MagnetEffect::new);
        TELEPORT = VineryEffects.registerEffect("teleport", TeleportEffect::new);
        IMPROVED_ABSORBTION = VineryEffects.registerEffect("improved_absorbtion", ImprovedAbsorbtion::new);
        CREEPER_EFFECT = VineryEffects.registerEffect("creeper_effect", CreeperEffect::new);
        IMPROVED_SPEED = VineryEffects.registerEffect("improved_speed", () -> new ImprovedEffect(MobEffectCategory.BENEFICIAL, 5735347).m_19472_(Attributes.f_22279_, "8614E716-3E4B-D398-9CA2-2F9368FF8635", 0.2f, AttributeModifier.Operation.MULTIPLY_TOTAL));
        IMPROVED_JUMP_BOOST = VineryEffects.registerEffect("improved_jump_boost", () -> new ImprovedEffect(MobEffectCategory.BENEFICIAL, 9500817));
        IMPROVED_STRENGTH = VineryEffects.registerEffect("improved_strength", () -> new ImprovedEffect(MobEffectCategory.BENEFICIAL, 12088116).m_19472_(Attributes.f_22283_, "AF739E3F-3B12-4C0A-ACD6-5BA291ADB183", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22281_, "649DC064-6A60-4029-C0BE-CB923001D7A9", 3.0, AttributeModifier.Operation.ADDITION));
        IMPROVED_INSTANT_HEALTH = VineryEffects.registerEffect("improved_instant_health", () -> new ImprovedInstantHealth(MobEffectCategory.BENEFICIAL, 16404772));
        IMPROVED_REGENERATION = VineryEffects.registerEffect("improved_regeneration", () -> new ImprovedRegeneration(MobEffectCategory.BENEFICIAL, 14904431).m_19472_(Attributes.f_22276_, "2DF48BAF-1526-71CC-B896-C6D44CEA0DA1", 4.0, AttributeModifier.Operation.ADDITION));
        IMPROVED_FIRE_RESISTANCE = VineryEffects.registerEffect("improved_fire_resistance", () -> new ImprovedEffect(MobEffectCategory.BENEFICIAL, 12542256));
        IMPROVED_WATER_BREATHING = VineryEffects.registerEffect("improved_water_breathing", () -> new ImprovedEffect(MobEffectCategory.BENEFICIAL, 7896181));
        IMPROVED_NIGHT_VISION = VineryEffects.registerEffect("improved_night_vision", () -> new ImprovedEffect(MobEffectCategory.BENEFICIAL, 5329821));
        IMPROVED_HASTE = VineryEffects.registerEffect("improved_haste", () -> new ImprovedEffect(MobEffectCategory.BENEFICIAL, 8891938).m_19472_(Attributes.f_22286_, "0C4EF750-C1D4-11ED-AFA1-02429C120002", 1.0, AttributeModifier.Operation.ADDITION).m_19472_(Attributes.f_22283_, "AF81723F-3D12-4C0A-AA36-5BA2BB9DBEF3", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }
}

