/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GeneralUtil {
    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return GeneralUtil.tracking(world, new ChunkPos(pos));
    }

    public static float getInPercent(int i) {
        return (float)i / 100.0f;
    }

    public static boolean isFullAndSolid(LevelReader levelReader, BlockPos blockPos) {
        return GeneralUtil.isFaceFull(levelReader, blockPos) && GeneralUtil.isSolid(levelReader, blockPos);
    }

    public static ItemStack convertStackAfterFinishUsing(LivingEntity entity, ItemStack used, Item returnItem, Item usedItem) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, used);
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)usedItem));
        }
        if (used.m_41619_()) {
            return new ItemStack((ItemLike)returnItem);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!((Player)entity).m_150110_().f_35937_) {
                ItemStack itemStack2 = new ItemStack((ItemLike)returnItem);
                if (!player.m_150109_().m_36054_(itemStack2)) {
                    player.m_36176_(itemStack2, false);
                }
            }
        }
        return used;
    }

    public static InteractionResult fillBucket(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack, ItemStack returnItem, BlockState blockState, SoundEvent soundEvent) {
        if (!level.f_46443_) {
            Item item = itemStack.m_41720_();
            player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)returnItem));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(blockPos, blockState);
            level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157816_, blockPos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult emptyBucket(Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, ItemStack itemStack, ItemStack returnItem, BlockState blockState, SoundEvent soundEvent) {
        if (!level.f_46443_) {
            Item item = itemStack.m_41720_();
            player.m_21008_(interactionHand, ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)returnItem));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            level.m_46597_(blockPos, blockState);
            level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, blockPos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static boolean isFaceFull(LevelReader levelReader, BlockPos blockPos) {
        BlockPos belowPos = blockPos.m_7495_();
        return Block.m_49918_((VoxelShape)levelReader.m_8055_(belowPos).m_60808_((BlockGetter)levelReader, belowPos), (Direction)Direction.UP);
    }

    public static boolean isSolid(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.m_8055_(blockPos.m_7495_()).m_280296_();
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    public static RotatedPillarBlock logBlock() {
        return new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_));
    }

    public static boolean isDamageType(DamageSource source, List<ResourceKey<DamageType>> damageTypes) {
        for (ResourceKey<DamageType> key : damageTypes) {
            if (!source.m_276093_(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFire(DamageSource source) {
        return GeneralUtil.isDamageType(source, List.of(DamageTypes.f_268468_, DamageTypes.f_268631_, DamageTypes.f_268684_, DamageTypes.f_268428_, DamageTypes.f_268556_));
    }

    public static boolean matchesRecipe(Container inventory, NonNullList<Ingredient> recipe, int startIndex, int endIndex) {
        ArrayList<ItemStack> validStacks = new ArrayList<ItemStack>();
        for (int i = startIndex; i <= endIndex; ++i) {
            ItemStack stackInSlot = inventory.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            validStacks.add(stackInSlot);
        }
        for (Ingredient entry : recipe) {
            boolean matches = false;
            for (ItemStack item : validStacks) {
                if (!entry.test(item)) continue;
                matches = true;
                validStacks.remove(item);
                break;
            }
            if (matches) continue;
            return false;
        }
        return true;
    }

    public static NonNullList<Ingredient> deserializeIngredients(JsonArray json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 0; i < json.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get(i));
            if (ingredient.m_43947_()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public static boolean isIndexInRange(int index, int startInclusive, int endInclusive) {
        return index >= startInclusive && index <= endInclusive;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83148_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (BooleanOp)BooleanOp.f_82695_);
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static FriendlyByteBuf create() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    public static Optional<Tuple<Float, Float>> getRelativeHitCoordinatesForBlockFace(BlockHitResult blockHitResult, Direction direction, Direction[] unAllowedDirections) {
        Direction direction2 = blockHitResult.m_82434_();
        if (unAllowedDirections == null) {
            unAllowedDirections = new Direction[]{Direction.DOWN, Direction.UP};
        }
        if (Arrays.stream(unAllowedDirections).toList().contains(direction2)) {
            return Optional.empty();
        }
        if (direction != direction2 && direction2 != Direction.UP && direction2 != Direction.DOWN) {
            return Optional.empty();
        }
        BlockPos blockPos = blockHitResult.m_82425_().m_121945_(direction2);
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        float d = (float)vec3.m_7096_();
        float f = (float)vec3.m_7094_();
        float y = (float)vec3.m_7098_();
        if (direction2 == Direction.UP || direction2 == Direction.DOWN) {
            direction2 = direction;
        }
        return switch (direction2) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Optional.of(new Tuple((Object)Float.valueOf((float)(1.0 - (double)d)), (Object)Float.valueOf(y)));
            case Direction.SOUTH -> Optional.of(new Tuple((Object)Float.valueOf(d), (Object)Float.valueOf(y)));
            case Direction.WEST -> Optional.of(new Tuple((Object)Float.valueOf(f), (Object)Float.valueOf(y)));
            case Direction.EAST -> Optional.of(new Tuple((Object)Float.valueOf((float)(1.0 - (double)f)), (Object)Float.valueOf(y)));
            case Direction.DOWN, Direction.UP -> Optional.empty();
        };
    }
}

