/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.capabilities.MapCollectionCap;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;

public class MapAtlasCompatImpl {
    public static boolean isAtlas(Item item) {
        return item instanceof MapAtlasItem;
    }

    @Nullable
    public static MapItemSavedData getSavedDataFromAtlas(ItemStack atlas, Level level, Player player) {
        MapCollectionCap maps = MapAtlasItem.getMaps((ItemStack)atlas, (Level)level);
        if (maps != null) {
            Integer slice = MapAtlasItem.getSelectedSlice((ItemStack)atlas, (ResourceKey)level.m_46472_());
            MapKey key = MapKey.at((byte)maps.getScale(), (Player)player, (Integer)slice);
            Pair select = maps.select(key);
            if (select != null) {
                return (MapItemSavedData)select.getSecond();
            }
        }
        return null;
    }

    @Nullable
    public static Integer getMapIdFromAtlas(ItemStack atlas, Level level, Object data) {
        try {
            MapCollectionCap maps = MapAtlasItem.getMaps((ItemStack)atlas, (Level)level);
            if (maps != null) {
                for (Pair e : maps.getAll()) {
                    if (e.getSecond() != data) continue;
                    return MapAtlasesAccessUtils.getMapIntFromString((String)((String)e.getFirst()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void scaleDecoration(PoseStack poseStack) {
        MapAtlasesClient.modifyDecorationTransform((PoseStack)poseStack);
    }
}

