/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class DecorationRenderer<T extends CustomMapDecoration> {
    protected final ResourceLocation textureId;
    protected final int mapColor;
    protected final boolean renderOnFrame;

    public DecorationRenderer(ResourceLocation texture, int mapColor, boolean renderOnFrame) {
        this.renderOnFrame = renderOnFrame;
        this.mapColor = mapColor;
        this.textureId = texture;
    }

    public DecorationRenderer(ResourceLocation texture, int mapColor) {
        this(texture, mapColor, true);
    }

    public DecorationRenderer(ResourceLocation texture) {
        this(texture, -1, true);
    }

    public int getColor(T decoration) {
        return this.mapColor;
    }

    public boolean render(T decoration, PoseStack matrixStack, VertexConsumer vertexBuilder, MultiBufferSource buffer, @Nullable MapItemSavedData mapData, boolean isOnFrame, int light, int index) {
        if (!isOnFrame || this.renderOnFrame) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f + (float)((CustomMapDecoration)decoration).getX() / 2.0f + 64.0f, 0.0f + (float)((CustomMapDecoration)decoration).getY() / 2.0f + 64.0f, -0.02f);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_((float)(((CustomMapDecoration)decoration).getRot() * 360) / 16.0f));
            matrixStack.m_85841_(4.0f, 4.0f, 3.0f);
            if (MapHelper.MAP_ATLASES) {
                MapAtlasCompat.scaleDecoration(matrixStack);
            }
            Matrix4f matrix4f1 = matrixStack.m_85850_().m_252922_();
            int color = this.getColor(decoration);
            int b = FastColor.ARGB32.m_13669_((int)color);
            int g = FastColor.ARGB32.m_13667_((int)color);
            int r = FastColor.ARGB32.m_13665_((int)color);
            TextureAtlasSprite sprite = MapDecorationClientManager.getAtlasSprite(this.textureId);
            float u0 = sprite.m_118367_(0.0);
            float u1 = sprite.m_118367_(16.0);
            float v0 = sprite.m_118393_(0.0);
            float v1 = sprite.m_118393_(16.0);
            vertexBuilder.m_252986_(matrix4f1, -1.0f, 1.0f, (float)index * -0.001f).m_6122_(r, g, b, 255).m_7421_(u0, v1).m_85969_(light).m_5752_();
            vertexBuilder.m_252986_(matrix4f1, 1.0f, 1.0f, (float)index * -0.001f).m_6122_(r, g, b, 255).m_7421_(u1, v1).m_85969_(light).m_5752_();
            vertexBuilder.m_252986_(matrix4f1, 1.0f, -1.0f, (float)index * -0.001f).m_6122_(r, g, b, 255).m_7421_(u1, v0).m_85969_(light).m_5752_();
            vertexBuilder.m_252986_(matrix4f1, -1.0f, -1.0f, (float)index * -0.001f).m_6122_(r, g, b, 255).m_7421_(u0, v0).m_85969_(light).m_5752_();
            matrixStack.m_85849_();
            if (((CustomMapDecoration)decoration).getDisplayName() != null) {
                Font font = Minecraft.m_91087_().f_91062_;
                Component displayName = ((CustomMapDecoration)decoration).getDisplayName();
                float width = font.m_92852_((FormattedText)displayName);
                float clamped = Mth.m_14036_((float)(25.0f / width), (float)0.0f, (float)0.6666667f);
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)(0.0f + (float)((CustomMapDecoration)decoration).getX() / 2.0f + 64.0f - width * clamped / 2.0f), (double)(0.0f + (float)((CustomMapDecoration)decoration).getY() / 2.0f + 64.0f + 4.0f), (double)-0.025f);
                matrixStack.m_85841_(clamped, clamped, 1.0f);
                matrixStack.m_85837_(0.0, 0.0, (double)-0.1f);
                font.m_272077_(displayName, 0.0f, 0.0f, -1, false, matrixStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, Integer.MIN_VALUE, light);
                matrixStack.m_85849_();
            }
            return true;
        }
        return false;
    }
}

