/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class StaticResource {
    public final byte[] data;
    public final ResourceLocation location;
    public final String sourceName;

    private StaticResource(byte[] data, ResourceLocation location, String sourceName) {
        this.data = data;
        this.location = location;
        this.sourceName = sourceName;
    }

    public static StaticResource of(Resource original, ResourceLocation location) {
        byte[] data1 = new byte[]{};
        try (InputStream stream = original.m_215507_();){
            try {
                data1 = stream.readAllBytes();
            }
            catch (IOException e) {
                Moonlight.LOGGER.error("Could not parse resource: {}", (Object)location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new StaticResource(data1, location, original.m_215506_());
    }

    public static StaticResource create(byte[] data, ResourceLocation location) {
        return new StaticResource(data, location, location.toString());
    }

    @Nullable
    public static StaticResource getOrLog(ResourceManager manager, ResourceLocation location) {
        try {
            return StaticResource.of((Resource)manager.m_213713_(location).get(), location);
        }
        catch (Exception var4) {
            Moonlight.LOGGER.error("Could not find resource {}", (Object)location);
            return null;
        }
    }

    public static StaticResource getOrFail(ResourceManager manager, ResourceLocation location) throws NoSuchElementException {
        return StaticResource.of((Resource)manager.m_213713_(location).get(), location);
    }

    public JsonObject toJson() {
        JsonObject jsonObject;
        ByteArrayInputStream s = new ByteArrayInputStream(this.data);
        try {
            jsonObject = RPUtils.deserializeJson(s);
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        s.close();
        return jsonObject;
    }
}

