/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.client.SoftFluidParticleColors;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MoonlightClient {
    public static final Supplier<Boolean> MERGE_PACKS;
    public static final Supplier<Boolean> LAZY_MAP_DATA;
    private static MergedDynamicTexturePack mergedDynamicPack;

    public static void initClient() {
        ClientHelper.addClientReloadListener(SoftFluidParticleColors::new, Moonlight.res("soft_fluids"));
        ClientHelper.addClientReloadListener(MapDecorationClientManager::new, Moonlight.res("map_markers"));
    }

    public static DynamicTexturePack maybeMergePack(DynamicTexturePack pack) {
        if (mergedDynamicPack == null) {
            mergedDynamicPack = new MergedDynamicTexturePack(){};
        }
        Set<String> nameSpaces = pack.m_5698_(pack.getPackType());
        for (String n : nameSpaces) {
            mergedDynamicPack.addNamespaces(n);
        }
        ++MoonlightClient.mergedDynamicPack.mods;
        return mergedDynamicPack;
    }

    public static void afterTextureReload() {
        DynamicResourcePack.clearAfterReload(true);
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create("moonlight", ConfigType.CLIENT);
        MERGE_PACKS = builder.comment("Merge all dynamic resource packs from all mods that use this library into a single pack").define("merge_dynamic_packs", true);
        LAZY_MAP_DATA = builder.comment("Prevents map texture from being upladed to GPU when only map markers have changed.Could increase performance").define("lazy_map_upload", true);
        builder.buildAndRegister().loadFromFile();
    }

    private static class MergedDynamicTexturePack
    extends DynamicTexturePack {
        int mods = 0;

        public MergedDynamicTexturePack() {
            super(Moonlight.res("mods_dynamic_assets"));
        }

        @Override
        public Component makeDescription() {
            return Component.m_237113_((String)("Dynamic resources for " + this.mods + (this.mods == 1 ? " mod" : " mods")));
        }
    }
}

