/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import io.netty.buffer.Unpooled;
import java.util.Collection;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientboundMapItemDataPacket.class})
public class MapItemDataPacketMixin
implements IMapDataPacketExtension {
    @Shadow
    @Final
    @Nullable
    private MapItemSavedData.MapPatch f_178968_;
    @Unique
    private CustomMapDecoration[] moonlight$customDecorations = null;
    @Unique
    private CustomMapData[] moonlight$customData = null;
    @Unique
    private int moonlight$mapCenterX = 0;
    @Unique
    private int moonlight$mapCenterZ = 0;
    @Unique
    private ResourceLocation moonlight$dimension = Level.f_46428_.m_135782_();

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")})
    private void readExtraData(FriendlyByteBuf buf, CallbackInfo ci) {
        Object type;
        int m;
        this.moonlight$dimension = buf.m_130281_();
        this.moonlight$mapCenterX = buf.m_130242_();
        this.moonlight$mapCenterZ = buf.m_130242_();
        if (buf.readBoolean()) {
            for (m = 0; m < this.moonlight$customDecorations.length; ++m) {
                type = MapDecorationRegistry.get(buf.m_130281_());
                if (type == null) continue;
                this.moonlight$customDecorations[m] = ((MapDecorationType)type).loadDecorationFromBuffer(buf);
            }
        }
        if (buf.readBoolean()) {
            this.moonlight$customData = new CustomMapData[buf.m_130242_()];
            for (m = 0; m < this.moonlight$customData.length; ++m) {
                type = MapDecorationRegistry.CUSTOM_MAP_DATA_TYPES.getOrDefault(buf.m_130281_(), null);
                if (type == null) continue;
                this.moonlight$customData[m] = ((CustomMapData.Type)type).createFromBuffer(buf);
            }
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeExtraData(FriendlyByteBuf buf, CallbackInfo ci) {
        buf.m_130085_(this.moonlight$dimension);
        buf.m_130130_(this.moonlight$mapCenterX);
        buf.m_130130_(this.moonlight$mapCenterZ);
        buf.writeBoolean(this.moonlight$customDecorations != null);
        if (this.moonlight$customDecorations != null) {
            buf.m_130130_(this.moonlight$customDecorations.length);
            for (CustomMapDecoration decoration : this.moonlight$customDecorations) {
                buf.m_130085_(Utils.getID(decoration.getType()));
                decoration.saveToBuffer(buf);
            }
        }
        buf.writeBoolean(this.moonlight$customData != null);
        if (this.moonlight$customData != null) {
            buf.m_130130_(this.moonlight$customData.length);
            for (CustomMapData data : this.moonlight$customData) {
                buf.m_130085_(data.getType().id());
                data.saveToBuffer(buf);
            }
        }
    }

    @Override
    public void moonlight$sendCustomDecorations(Collection<CustomMapDecoration> decorations) {
        if (PlatHelper.getPhysicalSide().isClient()) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            decorations = decorations.stream().map(e -> {
                e.saveToBuffer(buffer);
                Object d = e.getType().loadDecorationFromBuffer(buffer);
                return d;
            }).toList();
        }
        this.moonlight$customDecorations = (CustomMapDecoration[])decorations.toArray(CustomMapDecoration[]::new);
    }

    @Override
    public void moonlight$sendCustomMapData(Collection<CustomMapData> data) {
        if (PlatHelper.getPhysicalSide().isClient()) {
            data = data.stream().map(e -> {
                CompoundTag tag = new CompoundTag();
                e.save(tag);
                CustomMapData n = (CustomMapData)e.getType().factory().apply(tag);
                return n;
            }).toList();
        }
        this.moonlight$customData = (CustomMapData[])data.toArray(CustomMapData[]::new);
    }

    @Override
    public void moonlight$sendCenterAndDimension(int centerX, int centerZ, ResourceLocation dimension) {
        this.moonlight$mapCenterX = centerX;
        this.moonlight$mapCenterZ = centerZ;
        this.moonlight$dimension = dimension;
    }

    @Override
    public CustomMapData[] moonlight$getCustomMapData() {
        return this.moonlight$customData;
    }

    @Override
    public CustomMapDecoration[] moonlight$getCustomDecorations() {
        return new CustomMapDecoration[0];
    }

    @Override
    public Vector2i moonlight$getMapCenter() {
        return new Vector2i(this.moonlight$mapCenterX, this.moonlight$mapCenterZ);
    }

    @Override
    public MapItemSavedData.MapPatch moonlight$getColorPatch() {
        return this.f_178968_;
    }

    @Override
    public ResourceKey<Level> moonlight$getDimension() {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.moonlight$dimension);
    }
}

