/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.forge.client;

import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.BookModel;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookContentResourceListenerLoader;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.handler.BookRightClickHandler;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.client.handler.TooltipHandler;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;
import vazkii.patchouli.common.item.PatchouliItems;

@Mod.EventBusSubscriber(modid="patchouli", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeClientInitializer {
    private static final Lock BOOK_LOAD_LOCK = new ReentrantLock();
    private static final Condition BOOK_LOAD_CONDITION = BOOK_LOAD_LOCK.newCondition();
    private static boolean booksLoaded = false;

    public static void signalBooksLoaded() {
        BOOK_LOAD_LOCK.lock();
        booksLoaded = true;
        BOOK_LOAD_CONDITION.signalAll();
        BOOK_LOAD_LOCK.unlock();
    }

    private static List<ResourceLocation> getBookModels() {
        BOOK_LOAD_LOCK.lock();
        try {
            while (!booksLoaded) {
                BOOK_LOAD_CONDITION.awaitUninterruptibly();
            }
            List<ResourceLocation> list = BookRegistry.INSTANCE.books.values().stream().map(b -> b.model).toList();
            return list;
        }
        finally {
            BOOK_LOAD_LOCK.unlock();
        }
    }

    @SubscribeEvent
    public static void modelRegistry(ModelEvent.RegisterAdditional e) {
        ForgeClientInitializer.getBookModels().stream().map(model -> new ModelResourceLocation(model, "inventory")).forEach(arg_0 -> ((ModelEvent.RegisterAdditional)e).register(arg_0));
        ItemPropertyFunction prop = (stack, world, entity, seed) -> ItemModBook.getCompletion(stack);
        ItemProperties.register((Item)PatchouliItems.BOOK, (ResourceLocation)new ResourceLocation("patchouli", "completion"), (ItemPropertyFunction)prop);
    }

    @SubscribeEvent
    public static void registerReloadListeners(RegisterClientReloadListenersEvent e) {
        e.registerReloadListener((PreparableReloadListener)BookContentResourceListenerLoader.INSTANCE);
        e.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                PatchouliAPI.LOGGER.info("Reloading resource pack-based books, world is nonnull");
                ClientBookRegistry.INSTANCE.reload();
            } else {
                PatchouliAPI.LOGGER.info("Not reloading resource pack-based books as client world is missing");
            }
        }));
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent evt) {
        evt.registerAbove(VanillaGuiOverlay.CROSSHAIR.id(), "book_right_click", (gui, poseStack, partialTick, width, height) -> BookRightClickHandler.onRenderHUD(poseStack, partialTick));
        evt.registerBelow(VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id(), "multiblock_progress", (gui, poseStack, partialTick, width, height) -> MultiblockVisualizationHandler.onRenderHUD(poseStack, partialTick));
    }

    @SubscribeEvent
    public static void onInitializeClient(FMLClientSetupEvent evt) {
        ClientBookRegistry.INSTANCE.init();
        PersistentData.setup();
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                ClientTicker.endClientTick(Minecraft.m_91087_());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> BookRightClickHandler.onRightClick(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec()));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            InteractionResult result = MultiblockVisualizationHandler.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
            if (result.m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                MultiblockVisualizationHandler.onClientTick(Minecraft.m_91087_());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.START) {
                ClientTicker.renderTickStart(e.renderTickTime);
            } else {
                ClientTicker.renderTickEnd();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> ClientAdvancements.playerLogout());
        MinecraftForge.EVENT_BUS.addListener(e -> TooltipHandler.onTooltip(e.getGraphics(), e.getItemStack(), e.getX(), e.getY()));
    }

    @SubscribeEvent
    public static void replaceBookModel(ModelEvent.ModifyBakingResult evt) {
        BookModel.replace(evt.getModels(), evt.getModelBakery());
    }
}

