/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.recipe.ingredient.forge;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.CodecIngredient;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.forge.ForgeIngredientHelper;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ForgeIngredient<T extends CodecIngredient<T>>
extends AbstractIngredient {
    private final T ingredient;
    @Nullable
    private ItemStack[] stacks;
    @Nullable
    private IntList stackingIds;

    protected ForgeIngredient(T ingredient) {
        super(Stream.of(new Ingredient.Value[0]));
        this.ingredient = ingredient;
    }

    public T getIngredient() {
        return this.ingredient;
    }

    public ItemStack @NotNull [] m_43908_() {
        if (this.stacks == null) {
            this.stacks = this.ingredient.getStacksAsArray();
        }
        return this.stacks;
    }

    public boolean isSimple() {
        return !this.ingredient.isComplex();
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public boolean m_43947_() {
        return this.ingredient.isEmpty();
    }

    @NotNull
    public IntList m_43931_() {
        if (this.stackingIds == null) {
            this.stackingIds = Ingredient.m_43927_((ItemStack[])this.m_43908_()).m_43931_();
        }
        return this.stackingIds;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ForgeIngredientHelper.get(this.ingredient.serializer().id());
    }

    @NotNull
    public JsonElement m_43942_() {
        return (JsonElement)this.ingredient.serializer().codec().encodeStart((DynamicOps)JsonOps.INSTANCE, this.ingredient).getOrThrow(false, arg_0 -> ((Logger)Constants.LOGGER).error(arg_0));
    }
}

