/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.recipe.ingredient.forge;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.networking.PacketHelper;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.CodecIngredient;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.CodecIngredientSerializer;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.forge.ForgeIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ForgeIngredientSerializer<T extends CodecIngredient<T>>
implements IIngredientSerializer<ForgeIngredient<T>> {
    private final CodecIngredientSerializer<T> serializer;

    public ForgeIngredientSerializer(CodecIngredientSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public ResourceLocation id() {
        return this.serializer.id();
    }

    @NotNull
    public ForgeIngredient<T> parse(@NotNull JsonObject json) {
        CodecIngredient ingredient = (CodecIngredient)this.serializer.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)Constants.LOGGER).error(arg_0));
        return new ForgeIngredient<CodecIngredient>(ingredient);
    }

    @NotNull
    public ForgeIngredient<T> parse(@NotNull FriendlyByteBuf buf) {
        CodecIngredient ingredient = (CodecIngredient)PacketHelper.readWithYabn(buf, this.serializer.network(), true).getOrThrow(false, arg_0 -> ((Logger)Constants.LOGGER).error(arg_0));
        return new ForgeIngredient<CodecIngredient>(ingredient);
    }

    public void write(@NotNull FriendlyByteBuf buf, @NotNull ForgeIngredient<T> ingredient) {
        PacketHelper.writeWithYabn(buf, this.serializer.network(), ingredient.getIngredient(), true).getOrThrow(false, s -> Constants.LOGGER.error("Could not parse {}", ingredient.getIngredient()));
    }
}

