/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

public class ChunkCameraContext {
    private static final float PRECISION_MODIFIER = 128.0f;
    public final int blockX;
    public final int blockY;
    public final int blockZ;
    public final float deltaX;
    public final float deltaY;
    public final float deltaZ;
    public final double posX;
    public final double posY;
    public final double posZ;

    public ChunkCameraContext(double x, double y, double z) {
        this.blockX = (int)x;
        this.blockY = (int)y;
        this.blockZ = (int)z;
        float deltaXFullPrecision = (float)(x - (double)this.blockX);
        float deltaYFullPrecision = (float)(y - (double)this.blockY);
        float deltaZFullPrecision = (float)(z - (double)this.blockZ);
        float deltaXModifier = Math.copySign(128.0f, deltaXFullPrecision);
        float deltaYModifier = Math.copySign(128.0f, deltaYFullPrecision);
        float deltaZModifier = Math.copySign(128.0f, deltaZFullPrecision);
        this.deltaX = deltaXFullPrecision + deltaXModifier - deltaXModifier;
        this.deltaY = deltaYFullPrecision + deltaYModifier - deltaYModifier;
        this.deltaZ = deltaZFullPrecision + deltaZModifier - deltaZModifier;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }
}

