/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeBinding;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.DrawCommandList;
import me.jellysquid.mods.sodium.client.gl.device.MultiDrawBatch;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlIndexType;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlPrimitiveType;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlTessellation;
import me.jellysquid.mods.sodium.client.gl.tessellation.TessellationBinding;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.ShaderChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.SharedQuadIndexBuffer;
import me.jellysquid.mods.sodium.client.render.chunk.data.SectionRenderDataStorage;
import me.jellysquid.mods.sodium.client.render.chunk.data.SectionRenderDataUnsafe;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import me.jellysquid.mods.sodium.client.util.ReversibleArrayIterator;
import org.lwjgl.system.MemoryUtil;

public class RegionChunkRenderer
extends ShaderChunkRenderer {
    private final MultiDrawBatch batch = new MultiDrawBatch(ModelQuadFacing.COUNT * 256 + 1);
    private final SharedQuadIndexBuffer sharedIndexBuffer;

    public RegionChunkRenderer(RenderDevice device, ChunkVertexType vertexType) {
        super(device, vertexType);
        this.sharedIndexBuffer = new SharedQuadIndexBuffer(device.createCommandList(), SharedQuadIndexBuffer.IndexType.INTEGER);
    }

    @Override
    public void render(ChunkRenderMatrices matrices, CommandList commandList, RenderRegionManager regions, SortedRenderLists renderLists, TerrainRenderPass renderPass, ChunkCameraContext camera) {
        ChunkRenderList renderList;
        super.begin(renderPass);
        ChunkShaderInterface shader = (ChunkShaderInterface)this.activeProgram.getInterface();
        shader.setProjectionMatrix(matrices.projection());
        shader.setModelViewMatrix(matrices.modelView());
        ReversibleArrayIterator<ChunkRenderList> regionIterator = renderLists.sorted(renderPass.isReverseOrder());
        while ((renderList = regionIterator.next()) != null) {
            RenderRegion region = renderList.getRegion();
            SectionRenderDataStorage storage = region.getStorage(renderPass);
            if (storage == null) continue;
            RegionChunkRenderer.fillCommandBuffer(this.batch, storage, renderList, renderPass);
            if (this.batch.isEmpty()) continue;
            this.sharedIndexBuffer.ensureCapacity(commandList, this.batch.getIndexBufferSize());
            GlTessellation tessellation = this.prepareTessellation(commandList, region);
            RegionChunkRenderer.setModelMatrixUniforms(shader, region, camera);
            RegionChunkRenderer.executeDrawBatch(commandList, tessellation, this.batch);
        }
        super.end(renderPass);
    }

    private static void fillCommandBuffer(MultiDrawBatch batch, SectionRenderDataStorage storage, ChunkRenderList list, TerrainRenderPass pass) {
        batch.clear();
        ChunkRenderList.ReversibleSectionIterator sectionIterator = list.sectionsWithGeometryIterator(pass.isReverseOrder());
        if (sectionIterator == null) {
            return;
        }
        while (sectionIterator.hasNext()) {
            int next = sectionIterator.next();
            int sectionIndex = ChunkRenderList.unpackIndex(next);
            int sectionCulledFaces = ChunkRenderList.unpackFaces(next);
            long data = storage.getDataPointer(sectionIndex);
            int slices = sectionCulledFaces;
            if ((slices &= SectionRenderDataUnsafe.getSliceMask(data)) == 0) continue;
            RegionChunkRenderer.addDrawCommands(batch, data, slices);
        }
    }

    private static void addDrawCommands(MultiDrawBatch batch, long data, int mask) {
        long pBaseVertex = batch.pBaseVertex;
        long pElementCount = batch.pElementCount;
        int size = batch.size;
        for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
            MemoryUtil.memPutInt((long)(pBaseVertex + (long)(size << 2)), (int)SectionRenderDataUnsafe.getVertexOffset(data, facing));
            MemoryUtil.memPutInt((long)(pElementCount + (long)(size << 2)), (int)SectionRenderDataUnsafe.getElementCount(data, facing));
            size += mask >> facing & 1;
        }
        batch.size = size;
    }

    private static void setModelMatrixUniforms(ChunkShaderInterface shader, RenderRegion region, ChunkCameraContext camera) {
        float x = RegionChunkRenderer.getCameraTranslation(region.getOriginX(), camera.blockX, camera.deltaX);
        float y = RegionChunkRenderer.getCameraTranslation(region.getOriginY(), camera.blockY, camera.deltaY);
        float z = RegionChunkRenderer.getCameraTranslation(region.getOriginZ(), camera.blockZ, camera.deltaZ);
        shader.setRegionOffset(x, y, z);
    }

    private static float getCameraTranslation(int chunkBlockPos, int cameraBlockPos, float cameraPos) {
        return (float)(chunkBlockPos - cameraBlockPos) - cameraPos;
    }

    private GlTessellation prepareTessellation(CommandList commandList, RenderRegion region) {
        RenderRegion.DeviceResources resources = region.getResources();
        GlTessellation tessellation = resources.getTessellation();
        if (tessellation == null) {
            tessellation = this.createRegionTessellation(commandList, resources);
            resources.updateTessellation(commandList, tessellation);
        }
        return tessellation;
    }

    private GlTessellation createRegionTessellation(CommandList commandList, RenderRegion.DeviceResources resources) {
        return commandList.createTessellation(GlPrimitiveType.TRIANGLES, new TessellationBinding[]{TessellationBinding.forVertexBuffer(resources.getVertexBuffer(), new GlVertexAttributeBinding[]{new GlVertexAttributeBinding(1, this.vertexFormat.getAttribute(ChunkMeshAttribute.POSITION_MATERIAL_MESH)), new GlVertexAttributeBinding(2, this.vertexFormat.getAttribute(ChunkMeshAttribute.COLOR_SHADE)), new GlVertexAttributeBinding(3, this.vertexFormat.getAttribute(ChunkMeshAttribute.BLOCK_TEXTURE)), new GlVertexAttributeBinding(4, this.vertexFormat.getAttribute(ChunkMeshAttribute.LIGHT_TEXTURE))}), TessellationBinding.forElementBuffer(this.sharedIndexBuffer.getBufferObject())});
    }

    private static void executeDrawBatch(CommandList commandList, GlTessellation tessellation, MultiDrawBatch batch) {
        try (DrawCommandList drawCommandList = commandList.beginTessellating(tessellation);){
            drawCommandList.multiDrawElementsBaseVertex(batch, GlIndexType.UNSIGNED_INT);
        }
    }

    @Override
    public void delete(CommandList commandList) {
        super.delete(commandList);
        this.sharedIndexBuffer.delete(commandList);
        this.batch.delete();
    }
}

