/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkCameraContext;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkUpdateType;
import me.jellysquid.mods.sodium.client.render.chunk.RegionChunkRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import me.jellysquid.mods.sodium.client.render.chunk.graph.GraphDirection;
import me.jellysquid.mods.sodium.client.render.chunk.graph.VisibilityEncoding;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderListBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshFormats;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import me.jellysquid.mods.sodium.client.util.BitwiseMath;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.sorting.MergeSort;
import me.jellysquid.mods.sodium.client.util.task.CancellationToken;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderSectionManager {
    private final ChunkBuilder builder;
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sectionByPosition = new Long2ReferenceOpenHashMap();
    private final EnumMap<ChunkUpdateType, ArrayDeque<RenderSection>> rebuildQueues = new EnumMap(ChunkUpdateType.class);
    private final ConcurrentLinkedDeque<ChunkJobResult<ChunkBuildOutput>> buildResults = new ConcurrentLinkedDeque();
    private final ArrayDeque<RenderSection> iterationQueue = new ArrayDeque();
    private final ChunkRenderer chunkRenderer;
    private final ClientLevel world;
    private final int renderDistance;
    private int effectiveRenderDistance;
    private int centerChunkX;
    private int centerChunkY;
    private int centerChunkZ;
    private boolean needsUpdate;
    private boolean useOcclusionCulling;
    private boolean useBlockFaceCulling;
    private int currentFrame = 0;
    private boolean alwaysDeferChunkUpdates;
    @NotNull
    private final SortedRenderListBuilder renderListBuilder;
    @NotNull
    private SortedRenderLists renderLists;
    private final ReferenceSet<RenderSection> sectionsWithGlobalEntities = new ReferenceOpenHashSet();
    private static final int MODEL_UNASSIGNED = ModelQuadFacing.UNASSIGNED.ordinal();
    private static final int MODEL_POS_X = ModelQuadFacing.POS_X.ordinal();
    private static final int MODEL_NEG_X = ModelQuadFacing.NEG_X.ordinal();
    private static final int MODEL_POS_Y = ModelQuadFacing.POS_Y.ordinal();
    private static final int MODEL_NEG_Y = ModelQuadFacing.NEG_Y.ordinal();
    private static final int MODEL_POS_Z = ModelQuadFacing.POS_Z.ordinal();
    private static final int MODEL_NEG_Z = ModelQuadFacing.NEG_Z.ordinal();
    private static final double CHUNK_RENDER_BOUNDS_EPSILON = 0.03125;

    public RenderSectionManager(ClientLevel world, int renderDistance, CommandList commandList) {
        this.chunkRenderer = new RegionChunkRenderer(RenderDevice.INSTANCE, ChunkMeshFormats.COMPACT);
        this.world = world;
        this.builder = new ChunkBuilder(world, ChunkMeshFormats.COMPACT);
        this.needsUpdate = true;
        this.renderDistance = renderDistance;
        this.regions = new RenderRegionManager(commandList);
        this.sectionCache = new ClonedChunkSectionCache((Level)this.world);
        for (ChunkUpdateType type : ChunkUpdateType.values()) {
            this.rebuildQueues.put(type, new ArrayDeque());
        }
        this.renderListBuilder = new SortedRenderListBuilder();
        this.renderLists = SortedRenderLists.empty();
    }

    public void updateRenderLists(Camera camera, Viewport viewport, int frame, boolean spectator) {
        this.resetRenderLists();
        SortedRenderListBuilder renderListBuilder = this.renderListBuilder;
        renderListBuilder.reset();
        SodiumGameOptions options = SodiumClientMod.options();
        this.alwaysDeferChunkUpdates = options.performance.alwaysDeferChunkUpdates;
        this.searchChunks(renderListBuilder, camera, viewport, frame, spectator);
        this.renderLists = renderListBuilder.build();
        this.needsUpdate = false;
    }

    private void searchChunks(SortedRenderListBuilder renderListBuilder, Camera camera, Viewport viewport, int frame, boolean spectator) {
        this.initSearch(camera, viewport, frame, spectator);
        while (!this.iterationQueue.isEmpty()) {
            RenderSection section = this.iterationQueue.remove();
            int distance = this.getDistanceFromCamera(section);
            if (distance > this.effectiveRenderDistance || distance > 0 && this.isOutsideViewport(section, viewport)) continue;
            this.addToRenderLists(renderListBuilder, section);
            if (section.getPendingUpdate() != null && section.getBuildCancellationToken() == null) {
                this.addToRebuildLists(section);
            }
            int connections = this.useOcclusionCulling ? VisibilityEncoding.getConnections(section.getVisibilityData(), section.getIncomingDirections()) : 63;
            if ((connections &= this.getOutwardDirections(section.getChunkX(), section.getChunkY(), section.getChunkZ())) == 0) continue;
            this.searchNeighbors(section, connections);
        }
    }

    private void addToRenderLists(SortedRenderListBuilder renderListBuilder, RenderSection section) {
        renderListBuilder.add(section, this.getVisibleFaces(section.getChunkX(), section.getChunkY(), section.getChunkZ()));
    }

    private int getVisibleFaces(int x, int y, int z) {
        if (!this.useBlockFaceCulling) {
            return ModelQuadFacing.ALL;
        }
        int planes = 0;
        planes |= BitwiseMath.lessThan(x - 1, this.centerChunkX) << MODEL_POS_X;
        planes |= BitwiseMath.lessThan(y - 1, this.centerChunkY) << MODEL_POS_Y;
        planes |= BitwiseMath.lessThan(z - 1, this.centerChunkZ) << MODEL_POS_Z;
        planes |= BitwiseMath.greaterThan(x + 1, this.centerChunkX) << MODEL_NEG_X;
        planes |= BitwiseMath.greaterThan(y + 1, this.centerChunkY) << MODEL_NEG_Y;
        planes |= BitwiseMath.greaterThan(z + 1, this.centerChunkZ) << MODEL_NEG_Z;
        return planes |= 1 << MODEL_UNASSIGNED;
    }

    private void searchNeighbors(RenderSection section, int outgoing) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj;
            if ((outgoing & 1 << direction) == 0 || (adj = section.getAdjacent(direction)) == null) continue;
            this.bfsEnqueue(adj, 1 << GraphDirection.opposite(direction));
        }
    }

    private int getOutwardDirections(int x, int y, int z) {
        int planes = 0;
        planes |= x <= this.centerChunkX ? 16 : 0;
        planes |= x >= this.centerChunkX ? 32 : 0;
        planes |= y <= this.centerChunkY ? 1 : 0;
        planes |= y >= this.centerChunkY ? 2 : 0;
        planes |= z <= this.centerChunkZ ? 4 : 0;
        return planes |= z >= this.centerChunkZ ? 8 : 0;
    }

    private boolean isOutsideViewport(RenderSection section, Viewport viewport) {
        double maxZ;
        double maxY;
        double maxX;
        double z;
        double minZ;
        double y;
        double minY;
        double x = section.getOriginX();
        double minX = x - 0.03125;
        return !viewport.isBoxVisible(minX, minY = (y = (double)section.getOriginY()) - 0.03125, minZ = (z = (double)section.getOriginZ()) - 0.03125, maxX = x + 16.0 + 0.03125, maxY = y + 16.0 + 0.03125, maxZ = z + 16.0 + 0.03125);
    }

    private void addToRebuildLists(RenderSection section) {
        Queue queue = this.rebuildQueues.get((Object)section.getPendingUpdate());
        queue.add(section);
    }

    private void resetRenderLists() {
        for (Queue queue : this.rebuildQueues.values()) {
            queue.clear();
        }
        this.renderLists = SortedRenderLists.empty();
    }

    public void onSectionAdded(int x, int y, int z) {
        long key = SectionPos.m_123209_((int)x, (int)y, (int)z);
        if (this.sectionByPosition.containsKey(key)) {
            return;
        }
        RenderRegion region = this.regions.createForChunk(x, y, z);
        RenderSection renderSection = new RenderSection(region, x, y, z);
        region.addSection(renderSection);
        this.sectionByPosition.put(key, (Object)renderSection);
        LevelChunk chunk = this.world.m_6325_(x, z);
        LevelChunkSection section = chunk.m_7103_()[this.world.m_151566_(y)];
        if (section.m_188008_()) {
            this.updateSectionInfo(renderSection, BuiltSectionInfo.EMPTY);
        } else {
            renderSection.setPendingUpdate(ChunkUpdateType.INITIAL_BUILD);
        }
        this.connectNeighborNodes(renderSection);
        this.needsUpdate = true;
    }

    public void onSectionRemoved(int x, int y, int z) {
        RenderSection section = (RenderSection)this.sectionByPosition.remove(SectionPos.m_123209_((int)x, (int)y, (int)z));
        if (section == null) {
            return;
        }
        RenderRegion region = section.getRegion();
        if (region != null) {
            region.removeSection(section);
        }
        this.disconnectNeighborNodes(section);
        this.updateSectionInfo(section, null);
        section.delete();
        this.needsUpdate = true;
    }

    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrices, commandList, this.regions, this.renderLists, pass, new ChunkCameraContext(x, y, z));
        commandList.flush();
    }

    public void tickVisibleRenders() {
        Iterator<ChunkRenderList> it = this.renderLists.sorted();
        while (it.hasNext()) {
            ChunkRenderList renderList = it.next();
            RenderRegion region = renderList.getRegion();
            ChunkRenderList.SectionIterator iterator = renderList.sectionsWithSpritesIterator();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                TextureAtlasSprite[] sprites;
                RenderSection section = region.getSection(iterator.next());
                if (section == null || (sprites = section.getAnimatedSprites()) == null) continue;
                for (TextureAtlasSprite sprite : sprites) {
                    SpriteUtil.markSpriteActive(sprite);
                }
            }
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() == this.currentFrame;
    }

    public void updateChunks(boolean updateImmediately) {
        this.sectionCache.cleanup();
        this.regions.update();
        this.submitRebuildTasks(ChunkUpdateType.IMPORTANT_REBUILD, false);
        this.submitRebuildTasks(ChunkUpdateType.REBUILD, !updateImmediately);
        this.submitRebuildTasks(ChunkUpdateType.INITIAL_BUILD, !updateImmediately);
    }

    public void uploadChunks() {
        this.waitForBlockingTasks();
        ArrayList<ChunkBuildOutput> results = this.collectChunkBuildResults();
        if (!results.isEmpty()) {
            this.processChunkBuildResults(results);
            for (ChunkBuildOutput result : results) {
                result.delete();
            }
            this.needsUpdate = true;
        }
    }

    private void processChunkBuildResults(ArrayList<ChunkBuildOutput> results) {
        List<ChunkBuildOutput> filtered = RenderSectionManager.filterChunkBuildResults(results);
        this.regions.uploadMeshes(RenderDevice.INSTANCE.createCommandList(), filtered);
        for (ChunkBuildOutput result : filtered) {
            this.updateSectionInfo(result.render, result.info);
            CancellationToken job = result.render.getBuildCancellationToken();
            if (job != null && result.buildTime >= result.render.getLastSubmittedFrame()) {
                result.render.setBuildCancellationToken(null);
            }
            result.render.setLastBuiltFrame(result.buildTime);
        }
    }

    private void updateSectionInfo(RenderSection render, BuiltSectionInfo info) {
        render.setInfo(info);
        if (info == null || ArrayUtils.isEmpty((Object[])info.globalBlockEntities)) {
            this.sectionsWithGlobalEntities.remove((Object)render);
        } else {
            this.sectionsWithGlobalEntities.add((Object)render);
        }
    }

    private static List<ChunkBuildOutput> filterChunkBuildResults(ArrayList<ChunkBuildOutput> outputs) {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        for (ChunkBuildOutput output : outputs) {
            RenderSection render;
            ChunkBuildOutput previous;
            if (output.render.isDisposed() || output.render.getLastBuiltFrame() > output.buildTime || (previous = (ChunkBuildOutput)map.get((Object)(render = output.render))) != null && previous.buildTime >= output.buildTime) continue;
            map.put((Object)render, (Object)output);
        }
        return new ArrayList<ChunkBuildOutput>((Collection<ChunkBuildOutput>)map.values());
    }

    private ArrayList<ChunkBuildOutput> collectChunkBuildResults() {
        ChunkJobResult<ChunkBuildOutput> result;
        ArrayList<ChunkBuildOutput> results = new ArrayList<ChunkBuildOutput>();
        while ((result = this.buildResults.poll()) != null) {
            results.add(result.unwrap());
        }
        return results;
    }

    private void waitForBlockingTasks() {
        boolean shouldContinue;
        while (shouldContinue = this.builder.stealBlockingTask()) {
        }
    }

    private void submitRebuildTasks(ChunkUpdateType type, boolean asynchronous) {
        int budget = asynchronous ? this.builder.getSchedulingBudget() : Integer.MAX_VALUE;
        ArrayDeque<RenderSection> queue = this.rebuildQueues.get((Object)type);
        while (budget > 0 && !queue.isEmpty()) {
            RenderSection section = queue.poll();
            if (section.isDisposed()) continue;
            int frame = this.currentFrame;
            ChunkBuilderMeshingTask task = this.createRebuildTask(section, frame);
            if (task != null) {
                CancellationToken token = this.builder.scheduleTask(task, asynchronous, this.buildResults::add);
                section.setBuildCancellationToken(token);
            } else {
                ChunkJobResult<ChunkBuildOutput> result = ChunkJobResult.successfully(new ChunkBuildOutput(section, BuiltSectionInfo.EMPTY, Collections.emptyMap(), frame));
                this.buildResults.add(result);
                section.setBuildCancellationToken(null);
            }
            section.setLastSubmittedFrame(frame);
            section.setPendingUpdate(null);
            --budget;
        }
    }

    @Nullable
    public ChunkBuilderMeshingTask createRebuildTask(RenderSection render, int frame) {
        ChunkRenderContext context = WorldSlice.prepare((Level)this.world, render.getChunkPos(), this.sectionCache);
        if (context == null) {
            return null;
        }
        return new ChunkBuilderMeshingTask(render, context, frame);
    }

    public void markGraphDirty() {
        this.needsUpdate = true;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.builder.shutdown();
        for (ChunkBuildOutput result : this.collectChunkBuildResults()) {
            result.delete();
        }
        this.sectionsWithGlobalEntities.clear();
        this.resetRenderLists();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
            this.chunkRenderer.delete(commandList);
        }
    }

    public int getTotalSections() {
        return this.sectionByPosition.size();
    }

    public int getVisibleChunkCount() {
        int sections = 0;
        Iterator<ChunkRenderList> iterator = this.renderLists.sorted();
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            sections += renderList.getSectionsWithGeometryCount();
        }
        return sections;
    }

    public void scheduleRebuild(int x, int y, int z, boolean important) {
        this.sectionCache.invalidate(x, y, z);
        RenderSection section = (RenderSection)this.sectionByPosition.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
        if (section != null && section.isBuilt()) {
            ChunkUpdateType pendingUpdate = !this.alwaysDeferChunkUpdates && important ? ChunkUpdateType.IMPORTANT_REBUILD : ChunkUpdateType.REBUILD;
            if (ChunkUpdateType.canPromote(section.getPendingUpdate(), pendingUpdate)) {
                section.setPendingUpdate(pendingUpdate);
            }
        }
        this.needsUpdate = true;
    }

    private int getDistanceFromCamera(RenderSection section) {
        int x = Math.abs(section.getChunkX() - this.centerChunkX);
        int y = Math.abs(section.getChunkY() - this.centerChunkY);
        int z = Math.abs(section.getChunkZ() - this.centerChunkZ);
        return Math.max(x, Math.max(y, z));
    }

    private void initSearch(Camera camera, Viewport viewport, int frame, boolean spectator) {
        this.iterationQueue.clear();
        this.currentFrame = frame;
        SodiumGameOptions options = SodiumClientMod.options();
        this.effectiveRenderDistance = options.performance.useFogOcclusion ? Math.min(this.getEffectiveViewDistance(), this.renderDistance) : this.renderDistance;
        this.useBlockFaceCulling = options.performance.useBlockFaceCulling;
        BlockPos origin = camera.m_90588_();
        this.useOcclusionCulling = spectator && this.world.m_8055_(origin).m_60804_((BlockGetter)this.world, origin) ? false : Minecraft.m_91087_().f_90980_;
        this.centerChunkX = origin.m_123341_() >> 4;
        this.centerChunkY = origin.m_123342_() >> 4;
        this.centerChunkZ = origin.m_123343_() >> 4;
        if (this.centerChunkY < this.world.m_151560_()) {
            this.initSearchFallback(viewport, origin, this.centerChunkX, this.world.m_151560_(), this.centerChunkZ, 1);
        } else if (this.centerChunkY >= this.world.m_151561_()) {
            this.initSearchFallback(viewport, origin, this.centerChunkX, this.world.m_151561_() - 1, this.centerChunkZ, 2);
        } else {
            RenderSection node = this.getRenderSection(this.centerChunkX, this.centerChunkY, this.centerChunkZ);
            if (node != null) {
                this.bfsEnqueue(node, 63);
            }
        }
    }

    private void initSearchFallback(Viewport viewport, BlockPos origin, int chunkX, int chunkY, int chunkZ, int directions) {
        ArrayList<RenderSection> sections = new ArrayList<RenderSection>();
        for (int x2 = -this.effectiveRenderDistance; x2 <= this.effectiveRenderDistance; ++x2) {
            for (int z2 = -this.effectiveRenderDistance; z2 <= this.effectiveRenderDistance; ++z2) {
                RenderSection section = this.getRenderSection(chunkX + x2, chunkY, chunkZ + z2);
                if (section == null || this.isOutsideViewport(section, viewport)) continue;
                sections.add(section);
            }
        }
        if (!sections.isEmpty()) {
            this.bfsEnqueueAll(sections, origin, directions);
        }
    }

    private void bfsEnqueueAll(List<RenderSection> sections, BlockPos origin, int directions) {
        float[] distance = new float[sections.size()];
        for (int index = 0; index < sections.size(); ++index) {
            RenderSection section = sections.get(index);
            distance[index] = -section.getSquaredDistance(origin);
        }
        for (int index : MergeSort.mergeSort(distance)) {
            this.bfsEnqueue(sections.get(index), directions);
        }
    }

    private void bfsEnqueue(RenderSection render, int incomingDirections) {
        if (render.getLastVisibleFrame() != this.currentFrame) {
            render.setLastVisibleFrame(this.currentFrame);
            render.setIncomingDirections(0);
            this.iterationQueue.add(render);
        }
        render.addIncomingDirections(incomingDirections);
    }

    private int getEffectiveViewDistance() {
        float[] color = RenderSystem.getShaderFogColor();
        float distance = RenderSystem.getShaderFogEnd();
        if (!Mth.m_14033_((float)color[3], (float)1.0f)) {
            return this.renderDistance;
        }
        return Mth.m_14167_((float)(distance / 16.0f));
    }

    private void connectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + GraphDirection.x(direction), render.getChunkY() + GraphDirection.y(direction), render.getChunkZ() + GraphDirection.z(direction));
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), render);
            render.setAdjacentNode(direction, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = render.getAdjacent(direction);
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), null);
            render.setAdjacentNode(direction, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sectionByPosition.get(SectionPos.m_123209_((int)x, (int)y, (int)z));
    }

    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        long deviceUsed = 0L;
        long deviceAllocated = 0L;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            RenderRegion.DeviceResources resources = region.getResources();
            if (resources == null) continue;
            GlBufferArena buffer = resources.getGeometryArena();
            deviceUsed += (long)buffer.getDeviceUsedMemory();
            deviceAllocated += (long)buffer.getDeviceAllocatedMemory();
            ++count;
        }
        list.add(String.format("Device buffer objects: %d", count));
        list.add(String.format("Device memory: %d/%d MiB", MathUtil.toMib(deviceUsed), MathUtil.toMib(deviceAllocated)));
        list.add(String.format("Staging buffer: %s", this.regions.getStagingBuffer().toString()));
        list.add(String.format("Chunk builder: P=%02d | A=%02d | I=%02d", this.builder.getScheduledJobCount(), this.builder.getBusyThreadCount(), this.builder.getTotalThreadCount()));
        list.add(String.format("Chunk updates: U=%02d (P0=%03d | P1=%03d | P2=%05d)", this.buildResults.size(), this.rebuildQueues.get((Object)ChunkUpdateType.IMPORTANT_REBUILD).size(), this.rebuildQueues.get((Object)ChunkUpdateType.REBUILD).size(), this.rebuildQueues.get((Object)ChunkUpdateType.INITIAL_BUILD).size()));
        return list;
    }

    @NotNull
    public SortedRenderLists getRenderLists() {
        return this.renderLists;
    }

    public boolean isSectionBuilt(int x, int y, int z) {
        RenderSection section = this.getRenderSection(x, y, z);
        return section != null && section.isBuilt();
    }

    public void onChunkAdded(int x, int z) {
        for (int y = this.world.m_151560_(); y < this.world.m_151561_(); ++y) {
            this.onSectionAdded(x, y, z);
        }
    }

    public void onChunkRemoved(int x, int z) {
        for (int y = this.world.m_151560_(); y < this.world.m_151561_(); ++y) {
            this.onSectionRemoved(x, y, z);
        }
    }

    public Collection<RenderSection> getSectionsWithGlobalEntities() {
        return ReferenceSets.unmodifiable(this.sectionsWithGlobalEntities);
    }
}

