/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJob;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobQueue;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJobTyped;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import me.jellysquid.mods.sodium.client.util.task.CancellationToken;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkBuilder {
    static final Logger LOGGER = LogManager.getLogger((String)"ChunkBuilder");
    private volatile boolean isRunning;
    private final ChunkJobQueue queue = new ChunkJobQueue();
    private final List<Thread> threads = new ArrayList<Thread>();
    private final AtomicInteger busyThreadCount = new AtomicInteger();
    private final ChunkBuildContext localContext;

    public ChunkBuilder(ClientLevel world, ChunkVertexType vertexType) {
        int count = ChunkBuilder.getThreadCount();
        this.isRunning = true;
        for (int i = 0; i < count; ++i) {
            ChunkBuildContext context = new ChunkBuildContext(world, vertexType);
            WorkerRunnable worker = new WorkerRunnable(context);
            Thread thread = new Thread((Runnable)worker, "Chunk Render Task Executor #" + i);
            thread.setPriority(Math.max(0, 3));
            thread.start();
            this.threads.add(thread);
        }
        LOGGER.info("Started {} worker threads", (Object)this.threads.size());
        this.localContext = new ChunkBuildContext(world, vertexType);
    }

    public int getSchedulingBudget() {
        return Math.max(0, this.threads.size() - this.queue.size());
    }

    public void shutdown() {
        if (!this.isRunning) {
            throw new IllegalStateException("Worker threads are not running");
        }
        this.shutdownThreads();
        Collection<ChunkJob> jobs = this.queue.removeAll();
        for (ChunkJob job : jobs) {
            job.setCancelled();
        }
    }

    private void shutdownThreads() {
        this.isRunning = false;
        LOGGER.info("Stopping worker threads");
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        for (Thread thread : this.threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threads.clear();
    }

    public <TASK extends ChunkBuilderTask<OUTPUT>, OUTPUT> CancellationToken scheduleTask(TASK task, boolean asynchronous, Consumer<ChunkJobResult<OUTPUT>> consumer) {
        Validate.notNull(task, (String)"Task must be non-null", (Object[])new Object[0]);
        if (!this.isRunning) {
            throw new IllegalStateException("Executor is stopped");
        }
        ChunkJobTyped<TASK, OUTPUT> job = new ChunkJobTyped<TASK, OUTPUT>(task, consumer);
        this.queue.add(job, asynchronous);
        return job;
    }

    private static int getOptimalThreadCount() {
        return Mth.m_14045_((int)Math.max(ChunkBuilder.getMaxThreadCount() / 3, ChunkBuilder.getMaxThreadCount() - 6), (int)1, (int)10);
    }

    private static int getThreadCount() {
        int requested = SodiumClientMod.options().performance.chunkBuilderThreads;
        return requested == 0 ? ChunkBuilder.getOptimalThreadCount() : Math.min(requested, ChunkBuilder.getMaxThreadCount());
    }

    private static int getMaxThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public boolean stealBlockingTask() {
        ChunkJob job = this.queue.stealSynchronousJob();
        if (job == null) {
            return false;
        }
        ChunkBuildContext localContext = this.localContext;
        try {
            job.execute(localContext);
        }
        finally {
            localContext.cleanup();
        }
        return true;
    }

    public boolean isBuildQueueEmpty() {
        return this.queue.isEmpty();
    }

    public int getScheduledJobCount() {
        return this.queue.size();
    }

    public int getBusyThreadCount() {
        return this.busyThreadCount.get();
    }

    public int getTotalThreadCount() {
        return this.threads.size();
    }

    private class WorkerRunnable
    implements Runnable {
        private final ChunkBuildContext context;

        public WorkerRunnable(ChunkBuildContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            while (ChunkBuilder.this.isRunning) {
                ChunkJob job;
                try {
                    job = ChunkBuilder.this.queue.waitForNextJob();
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                if (job == null) continue;
                ChunkBuilder.this.busyThreadCount.getAndIncrement();
                try {
                    job.execute(this.context);
                }
                finally {
                    this.context.cleanup();
                    ChunkBuilder.this.busyThreadCount.decrementAndGet();
                }
            }
        }
    }
}

