/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.executor;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Semaphore;
import me.jellysquid.mods.sodium.client.render.chunk.compile.executor.ChunkJob;
import org.jetbrains.annotations.Nullable;

class ChunkJobQueue {
    private final ConcurrentLinkedDeque<ChunkJob> synchronousJobs = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedDeque<ChunkJob> asynchronousJobs = new ConcurrentLinkedDeque();
    private final Semaphore semaphore = new Semaphore(0);

    ChunkJobQueue() {
    }

    public void add(ChunkJob job, boolean asynchronous) {
        if (asynchronous) {
            this.asynchronousJobs.add(job);
        } else {
            this.synchronousJobs.add(job);
        }
        this.semaphore.release(1);
    }

    @Nullable
    public ChunkJob waitForNextJob() throws InterruptedException {
        this.semaphore.acquire();
        return this.getNextTask();
    }

    @Nullable
    public ChunkJob stealSynchronousJob() {
        if (!this.semaphore.tryAcquire()) {
            return null;
        }
        ChunkJob job = this.synchronousJobs.poll();
        if (job == null) {
            this.semaphore.release(1);
        }
        return job;
    }

    @Nullable
    private ChunkJob getNextTask() {
        ChunkJob job = this.synchronousJobs.poll();
        if (job != null) {
            return job;
        }
        job = this.asynchronousJobs.poll();
        if (job != null) {
            return job;
        }
        return job;
    }

    public Collection<ChunkJob> removeAll() {
        ArrayDeque<ChunkJob> list = new ArrayDeque<ChunkJob>();
        while (this.semaphore.tryAcquire()) {
            ChunkJob task = this.getNextTask();
            if (task == null) continue;
            list.add(task);
        }
        return list;
    }

    public int size() {
        return this.semaphore.availablePermits();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

