/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.lists;

import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import org.jetbrains.annotations.Nullable;

public class ChunkRenderList {
    private RenderRegion region;
    private final short[] sectionsWithGeometry = new short[257];
    private int sectionsWithGeometryCount = 0;
    private final byte[] sectionsWithSprites = new byte[257];
    private int sectionsWithSpritesCount = 0;
    private final byte[] sectionsWithEntities = new byte[257];
    private int sectionsWithEntitiesCount = 0;
    private int size;

    ChunkRenderList() {
    }

    public void init(RenderRegion region) {
        this.region = region;
        this.sectionsWithGeometryCount = 0;
        this.sectionsWithSpritesCount = 0;
        this.sectionsWithEntitiesCount = 0;
        this.size = 0;
    }

    public void add(RenderSection render, int faces) {
        if (this.size >= 256) {
            throw new ArrayIndexOutOfBoundsException("Render list is full");
        }
        ++this.size;
        int index = render.getSectionIndex();
        int flags = render.getFlags();
        this.sectionsWithGeometry[this.sectionsWithGeometryCount] = (short)ChunkRenderList.pack(index, faces);
        this.sectionsWithGeometryCount += flags >>> 0 & 1;
        this.sectionsWithSprites[this.sectionsWithSpritesCount] = (byte)index;
        this.sectionsWithSpritesCount += flags >>> 2 & 1;
        this.sectionsWithEntities[this.sectionsWithEntitiesCount] = (byte)index;
        this.sectionsWithEntitiesCount += flags >>> 1 & 1;
    }

    @Nullable
    public ReversibleSectionIterator sectionsWithGeometryIterator(boolean reverse) {
        if (this.sectionsWithGeometryCount == 0) {
            return null;
        }
        return new ReversibleSectionIterator(this.sectionsWithGeometry, 0, this.sectionsWithGeometryCount, reverse);
    }

    @Nullable
    public SectionIterator sectionsWithSpritesIterator() {
        if (this.sectionsWithSpritesCount == 0) {
            return null;
        }
        return new SectionIterator(this.sectionsWithSprites, this.sectionsWithSpritesCount);
    }

    @Nullable
    public SectionIterator sectionsWithEntitiesIterator() {
        if (this.sectionsWithEntitiesCount == 0) {
            return null;
        }
        return new SectionIterator(this.sectionsWithEntities, this.sectionsWithEntitiesCount);
    }

    public int getSectionsWithGeometryCount() {
        return this.sectionsWithGeometryCount;
    }

    public int getSectionsWithSpritesCount() {
        return this.sectionsWithSpritesCount;
    }

    public int getSectionsWithEntitiesCount() {
        return this.sectionsWithEntitiesCount;
    }

    public int getSize() {
        return this.size;
    }

    public RenderRegion getRegion() {
        return this.region;
    }

    public static int pack(int idx, int faces) {
        return (idx & 0xFF) << 0 | (faces & 0xFF) << 8;
    }

    public static int unpackIndex(int packed) {
        return packed >> 0 & 0xFF;
    }

    public static int unpackFaces(int packed) {
        return packed >> 8 & 0xFF;
    }

    public static class ReversibleSectionIterator {
        private final short[] elements;
        private final int step;
        private int cur;
        private int rem;

        public ReversibleSectionIterator(short[] elements, int start, int end, boolean reverse) {
            this.elements = elements;
            this.rem = end - start;
            this.step = reverse ? -1 : 1;
            this.cur = reverse ? end - 1 : start;
        }

        public boolean hasNext() {
            return this.rem > 0;
        }

        public int next() {
            int result = Short.toUnsignedInt(this.elements[this.cur]);
            this.cur += this.step;
            --this.rem;
            return result;
        }
    }

    public static class SectionIterator {
        private final byte[] elements;
        private final int lastIndex;
        private int index;

        public SectionIterator(byte[] elements, int lastIndex) {
            this.elements = elements;
            this.lastIndex = lastIndex;
            this.index = 0;
        }

        public boolean hasNext() {
            return this.index < this.lastIndex;
        }

        public int next() {
            return Byte.toUnsignedInt(this.elements[this.index++]);
        }
    }
}

