/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.lists;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import me.jellysquid.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;

public class SortedRenderListBuilder {
    private final Reference2ReferenceLinkedOpenHashMap<RenderRegion, ChunkRenderList> lists = new Reference2ReferenceLinkedOpenHashMap();
    private final ArrayDeque<ChunkRenderList> cache = new ArrayDeque();

    public void add(RenderSection render, int faces) {
        RenderRegion region = render.getRegion();
        ChunkRenderList list = (ChunkRenderList)this.lists.get((Object)region);
        if (list == null) {
            list = this.createRenderList(region);
            this.lists.put((Object)region, (Object)list);
        }
        list.add(render, faces);
    }

    private ChunkRenderList createRenderList(RenderRegion region) {
        ChunkRenderList renderList = this.cache.poll();
        if (renderList == null) {
            renderList = new ChunkRenderList();
        }
        renderList.init(region);
        return renderList;
    }

    public void reset() {
        this.cache.clear();
        this.cache.addAll((Collection<ChunkRenderList>)this.lists.values());
        this.lists.clear();
    }

    public SortedRenderLists build() {
        ObjectArrayList batches = new ObjectArrayList(this.lists.size());
        batches.addAll((Collection)this.lists.values());
        return new SortedRenderLists((ObjectArrayList<ChunkRenderList>)batches);
    }
}

