/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.vertex.builder;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import org.lwjgl.system.MemoryUtil;

public class ChunkMeshBufferBuilder {
    private final ChunkVertexEncoder encoder;
    private final int stride;
    private final int initialCapacity;
    private ByteBuffer buffer;
    private int count;
    private int capacity;
    private int sectionIndex;

    public ChunkMeshBufferBuilder(ChunkVertexType vertexType, int initialCapacity) {
        this.encoder = vertexType.getEncoder();
        this.stride = vertexType.getVertexFormat().getStride();
        this.buffer = null;
        this.capacity = initialCapacity;
        this.initialCapacity = initialCapacity;
    }

    public void push(ChunkVertexEncoder.Vertex[] vertices, Material material) {
        int vertexStart = this.count;
        int vertexCount = vertices.length;
        if (this.count + vertexCount >= this.capacity) {
            this.grow(this.stride * vertexCount);
        }
        long ptr = MemoryUtil.memAddress((ByteBuffer)this.buffer, (int)(this.count * this.stride));
        for (ChunkVertexEncoder.Vertex vertex : vertices) {
            ptr = this.encoder.write(ptr, material, vertex, (byte)this.sectionIndex);
        }
        this.count += vertexCount;
    }

    private void grow(int len) {
        int cap = Math.max(this.capacity * 2, this.capacity + len);
        this.setBufferSize(cap * this.stride);
    }

    private void setBufferSize(int capacity) {
        this.buffer = MemoryUtil.memRealloc((ByteBuffer)this.buffer, (int)(capacity * this.stride));
        this.capacity = capacity;
    }

    public void start(int sectionIndex) {
        this.count = 0;
        this.sectionIndex = sectionIndex;
        this.setBufferSize(this.initialCapacity);
    }

    public void destroy() {
        if (this.buffer != null) {
            MemoryUtil.memFree((Buffer)this.buffer);
        }
        this.buffer = null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public ByteBuffer slice() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No vertex data in buffer");
        }
        return MemoryUtil.memSlice((ByteBuffer)this.buffer, (int)0, (int)(this.stride * this.count));
    }

    public int count() {
        return this.count;
    }
}

