/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.vertex.format.impl;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import org.lwjgl.system.MemoryUtil;

public class CompactChunkVertex
implements ChunkVertexType {
    public static final GlVertexFormat<ChunkMeshAttribute> VERTEX_FORMAT = GlVertexFormat.builder(ChunkMeshAttribute.class, 20).addElement(ChunkMeshAttribute.POSITION_MATERIAL_MESH, 0, GlVertexAttributeFormat.UNSIGNED_SHORT, 4, false, true).addElement(ChunkMeshAttribute.COLOR_SHADE, 8, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true, false).addElement(ChunkMeshAttribute.BLOCK_TEXTURE, 12, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, false).addElement(ChunkMeshAttribute.LIGHT_TEXTURE, 16, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, true).build();
    public static final int STRIDE = 20;
    private static final int POSITION_MAX_VALUE = 65536;
    private static final int TEXTURE_MAX_VALUE = 65536;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;
    private static final float MODEL_SCALE = 4.8828125E-4f;
    private static final float MODEL_SCALE_INV = 2048.0f;
    private static final float TEXTURE_SCALE = 1.5258789E-5f;

    private static short encodeBlockTexture(float value) {
        return (short)(Math.min(0.99999994f, value) * 65536.0f);
    }

    private static short encodePosition(float v) {
        return (short)((8.0f + v) * 2048.0f);
    }

    @Override
    public float getTextureScale() {
        return 1.5258789E-5f;
    }

    @Override
    public float getPositionScale() {
        return 4.8828125E-4f;
    }

    @Override
    public float getPositionOffset() {
        return -8.0f;
    }

    @Override
    public GlVertexFormat<ChunkMeshAttribute> getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder getEncoder() {
        return (ptr, material, vertex, sectionIndex) -> {
            MemoryUtil.memPutShort((long)(ptr + 0L), (short)CompactChunkVertex.encodePosition(vertex.x));
            MemoryUtil.memPutShort((long)(ptr + 2L), (short)CompactChunkVertex.encodePosition(vertex.y));
            MemoryUtil.memPutShort((long)(ptr + 4L), (short)CompactChunkVertex.encodePosition(vertex.z));
            MemoryUtil.memPutShort((long)(ptr + 6L), (short)material.bits());
            MemoryUtil.memPutShort((long)(ptr + 7L), (short)sectionIndex);
            MemoryUtil.memPutInt((long)(ptr + 8L), (int)vertex.color);
            MemoryUtil.memPutShort((long)(ptr + 12L), (short)CompactChunkVertex.encodeBlockTexture(vertex.u));
            MemoryUtil.memPutShort((long)(ptr + 14L), (short)CompactChunkVertex.encodeBlockTexture(vertex.v));
            MemoryUtil.memPutInt((long)(ptr + 16L), (int)vertex.light);
            return ptr + 20L;
        };
    }
}

