/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds.driver.nvidia;

import me.jellysquid.mods.sodium.client.util.workarounds.platform.windows.WindowsDriverStoreVersion;

public record NvidiaDriverVersion(int major, int minor) {
    public static NvidiaDriverVersion parse(WindowsDriverStoreVersion version) throws ParseException {
        int minor;
        int major;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(version.major());
        buffer.append(version.minor());
        String string = buffer.toString();
        if (string.length() < 3 || string.length() > 6) {
            throw new ParseException(version);
        }
        try {
            major = Integer.parseInt(string.substring(string.length() - 5, string.length() - 2));
            minor = Integer.parseInt(string.substring(string.length() - 2));
        }
        catch (NumberFormatException e) {
            throw new ParseException(version, e);
        }
        return new NvidiaDriverVersion(major, minor);
    }

    public boolean isWithinRange(NvidiaDriverVersion oldest, NvidiaDriverVersion newest) {
        if (this.major < oldest.major || this.minor < oldest.minor) {
            return false;
        }
        return this.major < newest.major || this.minor < newest.minor;
    }

    public static class ParseException
    extends Exception {
        private ParseException(WindowsDriverStoreVersion version) {
            super(ParseException.getMessage(version));
        }

        private ParseException(WindowsDriverStoreVersion version, Exception inner) {
            super(ParseException.getMessage(version), inner);
        }

        private static String getMessage(WindowsDriverStoreVersion version) {
            return "Not a valid NVIDIA driver version (%s)".formatted(version);
        }
    }
}

