/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util.workarounds.probe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.jellysquid.mods.sodium.client.util.workarounds.probe.GraphicsAdapterInfo;
import me.jellysquid.mods.sodium.client.util.workarounds.probe.GraphicsAdapterVendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;

public class GraphicsAdapterProbe {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Rubidium-GraphicsAdapterProbe");
    private static List<GraphicsAdapterInfo> ADAPTERS;

    public static void findAdapters() {
        LOGGER.info("Searching for graphics cards...");
        SystemInfo systemInfo = new SystemInfo();
        HardwareAbstractionLayer hardwareInfo = systemInfo.getHardware();
        ArrayList<GraphicsAdapterInfo> results = new ArrayList<GraphicsAdapterInfo>();
        for (GraphicsCard graphicsCard : hardwareInfo.getGraphicsCards()) {
            GraphicsAdapterVendor vendor = GraphicsAdapterVendor.identifyVendorFromString(graphicsCard.getVendor());
            String name = graphicsCard.getName();
            String versionInfo = graphicsCard.getVersionInfo();
            GraphicsAdapterInfo info = new GraphicsAdapterInfo(vendor, name, versionInfo);
            results.add(info);
            LOGGER.info("Found graphics card: {}", (Object)info);
        }
        if (results.isEmpty()) {
            LOGGER.warn("No graphics cards were found. Either you have no hardware devices supporting 3D acceleration, or something has gone terribly wrong!");
        }
        ADAPTERS = results;
    }

    public static Collection<GraphicsAdapterInfo> getAdapters() {
        if (ADAPTERS == null) {
            throw new RuntimeException("Graphics adapters not probed yet");
        }
        return ADAPTERS;
    }
}

