/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.render.immediate.consumer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import net.caffeinemc.mods.sodium.api.memory.MemoryIntrinsics;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatRegistry;
import net.caffeinemc.mods.sodium.api.vertex.serializer.VertexSerializerRegistry;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BufferBuilder.class})
public abstract class BufferBuilderMixin
implements VertexBufferWriter {
    @Shadow
    private ByteBuffer f_85648_;
    @Shadow
    private int f_85654_;
    @Shadow
    private int f_85652_;
    @Unique
    private VertexFormatDescription format;
    @Unique
    private int stride;

    @Shadow
    protected abstract void m_85722_(int var1);

    @Inject(method={"setFormat"}, at={@At(value="FIELD", target="Lnet/minecraft/client/render/BufferBuilder;format:Lnet/minecraft/client/render/VertexFormat;", opcode=181)})
    private void onFormatChanged(VertexFormat format, CallbackInfo ci) {
        this.format = VertexFormatRegistry.instance().get(format);
        this.stride = format.m_86020_();
    }

    @Override
    public void push(MemoryStack stack, long src, int count, VertexFormatDescription format) {
        int length = count * this.stride;
        this.m_85722_(length + this.stride);
        long dst = MemoryUtil.memAddress((ByteBuffer)this.f_85648_, (int)this.f_85652_);
        if (format == this.format) {
            MemoryIntrinsics.copyMemory(src, dst, length);
        } else {
            this.copySlow(src, dst, count, format);
        }
        this.f_85654_ += count;
        this.f_85652_ += length;
    }

    @Unique
    private void copySlow(long src, long dst, int count, VertexFormatDescription format) {
        VertexSerializerRegistry.instance().get(format, this.format).serialize(src, dst, count);
    }
}

