/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui.hooks.debug;

import com.google.common.collect.Lists;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.util.NativeBuffer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={DebugScreenOverlay.class})
public abstract class DebugHudMixin {
    @Shadow
    private static long m_94050_(long bytes) {
        throw new UnsupportedOperationException();
    }

    @Redirect(method={"getRightText"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList([Ljava/lang/Object;)Ljava/util/ArrayList;", remap=false))
    private ArrayList<String> redirectRightTextEarly(Object[] elements) {
        ArrayList strings = Lists.newArrayList((Object[])((String[])elements));
        strings.add("");
        strings.add("Rubidium Renderer");
        strings.add(ChatFormatting.UNDERLINE + DebugHudMixin.getFormattedVersionText());
        SodiumWorldRenderer renderer = SodiumWorldRenderer.instanceNullable();
        if (renderer != null) {
            strings.addAll(renderer.getDebugStrings());
        }
        for (int i = 0; i < strings.size(); ++i) {
            String str = (String)strings.get(i);
            if (!str.startsWith("Allocated:")) continue;
            strings.add(i + 1, DebugHudMixin.getNativeMemoryString());
            break;
        }
        return strings;
    }

    @Unique
    private static String getFormattedVersionText() {
        String version = SodiumClientMod.getVersion();
        ChatFormatting color = version.endsWith("-dirty") ? ChatFormatting.RED : (version.contains("+rev.") ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.GREEN);
        return color + version;
    }

    @Unique
    private static String getNativeMemoryString() {
        return "Off-Heap: +" + DebugHudMixin.m_94050_(DebugHudMixin.getNativeMemoryUsage()) + "MB";
    }

    @Unique
    private static long getNativeMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed() + NativeBuffer.getTotalAllocated();
    }
}

