/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.render.model.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.quad.BakedQuadView;
import me.jellysquid.mods.sodium.client.render.immediate.model.BakedModelEncoder;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.render.vertex.VertexConsumerUtils;
import me.jellysquid.mods.sodium.client.util.DirectionUtil;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraftforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBlockRenderer.class})
public class BlockModelRendererMixin {
    @Unique
    private final RandomSource random = new SingleThreadedRandomSource(42L);

    @Inject(method={"renderModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderFast(PoseStack.Pose entry, VertexConsumer vertexConsumer, BlockState blockState, BakedModel bakedModel, float red, float green, float blue, int light, int overlay, ModelData modelData, RenderType renderType, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        RandomSource random = this.random;
        red = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
        green = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
        blue = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
        int defaultColor = ColorABGR.pack(red, green, blue, 1.0f);
        for (Direction direction : DirectionUtil.ALL_DIRECTIONS) {
            random.m_188584_(42L);
            List quads = bakedModel.getQuads(blockState, direction, random, modelData, renderType);
            if (quads.isEmpty()) continue;
            BlockModelRendererMixin.renderQuads(entry, writer, defaultColor, quads, light, overlay);
        }
        random.m_188584_(42L);
        List quads = bakedModel.getQuads(blockState, null, random, modelData, renderType);
        if (!quads.isEmpty()) {
            BlockModelRendererMixin.renderQuads(entry, writer, defaultColor, quads, light, overlay);
        }
    }

    @Unique
    private static void renderQuads(PoseStack.Pose matrices, VertexBufferWriter writer, int defaultColor, List<BakedQuad> quads, int light, int overlay) {
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad bakedQuad = quads.get(i);
            BakedQuadView quad = (BakedQuadView)bakedQuad;
            int color = quad.hasColor() ? defaultColor : -1;
            BakedModelEncoder.writeQuadVertices(writer, matrices, quad, color, light, overlay);
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
    }
}

