/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.WallLanternBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ClientSpecialModelsManager {
    private static final Map<Block, ResourceLocation> SPECIAL_MOUNT_TEXTURES = new IdentityHashMap<Block, ResourceLocation>();
    private static final Map<Block, ResourceLocation> SPECIAL_LANTERN_MODELS = new IdentityHashMap<Block, ResourceLocation>();
    private static final Set<Block> POSSIBLE_LANTERNS = new HashSet<Block>();
    private static boolean initialized = false;

    public static void refreshModels(ResourceManager manager) {
        ClientSpecialModelsManager.reloadTextures(manager);
        ClientSpecialModelsManager.reloadModels(manager);
    }

    private static void reloadModels(ResourceManager manager) {
        if (!initialized) {
            ClientSpecialModelsManager.initialize();
            initialized = true;
        }
        SPECIAL_LANTERN_MODELS.clear();
        for (Block l : POSSIBLE_LANTERNS) {
            ResourceLocation reg = Utils.getID((Block)l);
            Object namespace = reg.m_135827_().equals("minecraft") || reg.m_135827_().equals("supplementaries") ? "" : reg.m_135827_() + "/";
            String s = "block/custom_wall_lanterns/" + (String)namespace + reg.m_135815_();
            ResourceLocation fullPath = Supplementaries.res("models/" + s + ".json");
            Optional resource = manager.m_213713_(fullPath);
            if (!resource.isPresent()) continue;
            SPECIAL_LANTERN_MODELS.put(l, Supplementaries.res(s));
        }
    }

    private static void reloadTextures(ResourceManager manager) {
        if (!initialized) {
            ClientSpecialModelsManager.initialize();
            initialized = true;
        }
        SPECIAL_MOUNT_TEXTURES.clear();
        for (Block l : POSSIBLE_LANTERNS) {
            ResourceLocation reg = Utils.getID((Block)l);
            Object namespace = reg.m_135827_().equals("minecraft") || reg.m_135827_().equals("supplementaries") ? "" : reg.m_135827_() + "/";
            String s = "textures/block/wall_lanterns/" + (String)namespace + reg.m_135815_() + ".json";
            ResourceLocation fullPath = Supplementaries.res(s);
            Optional resource = manager.m_213713_(fullPath);
            if (!resource.isPresent()) continue;
            try {
                InputStream stream = ((Resource)resource.get()).m_215507_();
                try {
                    JsonObject bsElement = RPUtils.deserializeJson((InputStream)stream);
                    String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                    if (texture.isEmpty()) continue;
                    SPECIAL_MOUNT_TEXTURES.put(l, new ResourceLocation(texture));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void initialize() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Block i : BuiltInRegistries.f_256975_) {
            if (!WallLanternBlock.isValidBlock(i)) continue;
            builder.add((Object)i);
        }
        POSSIBLE_LANTERNS.clear();
        POSSIBLE_LANTERNS.addAll((Collection<Block>)builder.build());
    }

    @Nullable
    public static TextureAtlasSprite getTextureForLantern(Block block) {
        ResourceLocation res = SPECIAL_MOUNT_TEXTURES.get(block);
        if (res == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(res);
    }

    public static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        SPECIAL_LANTERN_MODELS.values().forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
    }

    public static BakedModel getWallLanternModel(BlockModelShaper blockModelShaper, BlockState lantern) {
        ResourceLocation special = SPECIAL_LANTERN_MODELS.get(lantern.m_60734_());
        if (special != null) {
            return ClientHelper.getModel((ModelManager)Minecraft.m_91087_().m_91304_(), (ResourceLocation)special);
        }
        return blockModelShaper.m_110893_(lantern);
    }
}

