/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlowerBoxBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlowerBoxBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)6.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH_FLOOR = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0);
    protected static final VoxelShape SHAPE_WEST_FLOOR = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)6.0, (double)16.0);
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL_0_15;
    public static final BooleanProperty FLOOR = ModBlockProperties.FLOOR;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public FlowerBoxBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(s -> (Integer)s.m_61143_((Property)LIGHT_LEVEL)));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, FLOOR, LIGHT_LEVEL});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        Direction dir = context.m_43719_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(dir == Direction.UP))).m_61124_((Property)FACING, (Comparable)(dir.m_122434_().m_122478_() ? context.m_8125_().m_122424_() : dir));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        FlowerBoxBlockTile tile;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof FlowerBoxBlockTile && (tile = (FlowerBoxBlockTile)blockEntity).isAccessibleBy(player)) {
            int ind;
            Direction dir = (Direction)state.m_61143_((Property)FACING);
            Vec3 v = hit.m_82450_();
            v = v.m_82492_((double)pos.m_123341_() - 1.0, 0.0, (double)pos.m_123343_() - 1.0);
            if (dir.m_122434_() == Direction.Axis.X) {
                double normalizedZ = Math.abs(v.f_82481_ % 1.0);
                ind = v.f_82481_ >= 2.0 ? 2 : (int)(normalizedZ / 0.3333333333333333);
                if (dir.m_122429_() < 0) {
                    ind = 2 - ind;
                }
            } else {
                double normalizedX = Math.abs(v.f_82479_ % 1.0);
                ind = v.f_82479_ >= 2.0 ? 2 : (int)(normalizedX / 0.3333333333333333);
                if (dir.m_122431_() > 0) {
                    ind = 2 - ind;
                }
            }
            return tile.interact(player, handIn, ind);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new FlowerBoxBlockTile(pPos, pState);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof FlowerBoxBlockTile) {
                FlowerBoxBlockTile tile = (FlowerBoxBlockTile)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean wall = (Boolean)state.m_61143_((Property)FLOOR) == false;
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> {
                if (wall) {
                    yield SHAPE_NORTH;
                }
                yield SHAPE_NORTH_FLOOR;
            }
            case Direction.SOUTH -> {
                if (wall) {
                    yield SHAPE_SOUTH;
                }
                yield SHAPE_NORTH_FLOOR;
            }
            case Direction.EAST -> {
                if (wall) {
                    yield SHAPE_EAST;
                }
                yield SHAPE_WEST_FLOOR;
            }
            case Direction.WEST -> wall ? SHAPE_WEST : SHAPE_WEST_FLOOR;
        };
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockUtil.addOptionalOwnership(placer, world, pos);
    }
}

