/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherArmBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpringLauncherHeadBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpringLauncherArmBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpringLauncherBlock
extends Block {
    protected static final VoxelShape PISTON_BASE_EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_WEST_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape PISTON_BASE_NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_UP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape PISTON_BASE_DOWN_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty EXTENDED = BlockStateProperties.f_61432_;

    public SpringLauncherBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(false)));
    }

    @PlatformOnly(value={"forge"})
    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return (Boolean)state.m_61143_((Property)EXTENDED) != false ? PushReaction.BLOCK : PushReaction.NORMAL;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)EXTENDED);
    }

    public boolean m_7923_(BlockState state) {
        return (Boolean)state.m_61143_((Property)EXTENDED);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, EXTENDED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)EXTENDED)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.DOWN -> PISTON_BASE_DOWN_AABB;
                default -> PISTON_BASE_UP_AABB;
                case Direction.NORTH -> PISTON_BASE_NORTH_AABB;
                case Direction.SOUTH -> PISTON_BASE_SOUTH_AABB;
                case Direction.WEST -> PISTON_BASE_WEST_AABB;
                case Direction.EAST -> PISTON_BASE_EAST_AABB;
            };
        }
        return Shapes.m_83144_();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.checkForMove(state, level, pos);
    }

    private void checkForMove(BlockState state, Level level, BlockPos pos) {
        if (!level.m_5776_()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            boolean isPowered = this.shouldBeExtended(level, pos, direction);
            BlockPos offset = pos.m_121955_(direction.m_122436_());
            if (isPowered && !((Boolean)state.m_61143_((Property)EXTENDED)).booleanValue()) {
                BlockState sand;
                Block block;
                if (direction == Direction.UP && (block = (sand = level.m_8055_(offset)).m_60734_()) instanceof FallingBlock) {
                    FallingBlock fb = (FallingBlock)block;
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 4);
                    fb.m_213897_(sand, (ServerLevel)level, offset, level.f_46441_);
                    level.m_7731_(pos, state, 4);
                }
                boolean hasBrokenBlock = false;
                BlockState targetBlock = level.m_8055_(offset);
                if (targetBlock.m_60811_() == PushReaction.DESTROY || targetBlock.m_60795_()) {
                    BlockEntity blockEntity = targetBlock.m_155947_() ? level.m_7702_(offset) : null;
                    SpringLauncherBlock.m_49892_((BlockState)targetBlock, (LevelAccessor)level, (BlockPos)offset, (BlockEntity)blockEntity);
                    hasBrokenBlock = true;
                }
                if (hasBrokenBlock) {
                    level.m_46597_(offset, (BlockState)((BlockState)ModRegistry.SPRING_LAUNCHER_ARM.get().m_49966_().m_61124_((Property)SpringLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)direction));
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)EXTENDED, (Comparable)Boolean.valueOf(true)));
                    level.m_5594_(null, pos, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.53f, level.f_46441_.m_188501_() * 0.25f + 0.45f);
                    level.m_142346_(null, GameEvent.f_223702_, pos);
                }
            } else if (!isPowered && ((Boolean)state.m_61143_((Property)EXTENDED)).booleanValue()) {
                BlockState bs = level.m_8055_(offset);
                if (bs.m_60734_() instanceof SpringLauncherHeadBlock && direction == bs.m_61143_((Property)FACING)) {
                    level.m_46597_(offset, (BlockState)((BlockState)ModRegistry.SPRING_LAUNCHER_ARM.get().m_49966_().m_61124_((Property)SpringLauncherArmBlock.EXTENDING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)direction));
                    level.m_5594_(null, pos, SoundEvents.f_12311_, SoundSource.BLOCKS, 0.53f, level.f_46441_.m_188501_() * 0.15f + 0.45f);
                    level.m_142346_(null, GameEvent.f_223703_, pos);
                } else if (bs.m_60734_() instanceof SpringLauncherArmBlock && direction == bs.m_61143_((Property)FACING) && level.m_7702_(offset) instanceof SpringLauncherArmBlockTile) {
                    level.m_186460_(pos, level.m_8055_(pos).m_60734_(), 1);
                }
            }
        }
    }

    private boolean shouldBeExtended(Level level, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !level.m_276987_(pos.m_121945_(direction), direction)) continue;
            return true;
        }
        if (level.m_276987_(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = pos.m_7494_();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !level.m_276987_(blockpos.m_121945_(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, level, pos, neighborBlock, fromPos, moving);
        this.checkForMove(state, level, pos);
    }
}

