/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class StructureLocator {
    private static final Comparator<Vector2i> COMPARATOR = (o1, o2) -> Float.compare(o1.lengthSquared(), o2.lengthSquared());

    @Nullable
    public static Pair<BlockPos, Holder<Structure>> findNearestRandomMapFeature(ServerLevel level, @NotNull HolderSet<Structure> targets, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated) {
        List<Pair<BlockPos, Holder<Structure>>> found = StructureLocator.findNearestMapFeatures(level, targets, pos, maximumChunkDistance, newlyGenerated, 1, true);
        if (!found.isEmpty()) {
            return found.get(0);
        }
        return null;
    }

    public static List<Pair<BlockPos, Holder<Structure>>> findNearestMapFeatures(ServerLevel level, @NotNull TagKey<Structure> tagKey, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, boolean selectRandom) {
        HolderSet.Named targets = level.m_9598_().m_175515_(Registries.f_256944_).m_203431_(tagKey).orElse(null);
        if (targets == null) {
            return List.of();
        }
        return StructureLocator.findNearestMapFeatures(level, (HolderSet<Structure>)targets, pos, maximumChunkDistance, newlyGenerated, requiredCount, selectRandom);
    }

    public static List<Pair<BlockPos, Holder<Structure>>> findNearestMapFeatures(ServerLevel level, HolderSet<Structure> taggedStructures, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, boolean selectRandom) {
        ArrayList<Pair<BlockPos, Holder<Structure>>> foundStructures = new ArrayList<Pair<BlockPos, Holder<Structure>>>();
        if (!level.m_7654_().m_129910_().m_246337_().m_247749_()) {
            return foundStructures;
        }
        List<Object> selectedTargets = taggedStructures.m_203614_().toList();
        ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
        double maxDist = Double.MAX_VALUE;
        if (selectRandom) {
            Holder selected = (Holder)selectedTargets.get(level.f_46441_.m_188503_(selectedTargets.size()));
            selectedTargets = List.of(selected);
        }
        Object2ObjectArrayMap reachableTargetsMap = new Object2ObjectArrayMap();
        ChunkGeneratorStructureState structureState = level.m_7726_().m_255415_();
        for (Holder holder : selectedTargets) {
            for (StructurePlacement structureplacement : structureState.m_255260_(holder)) {
                reachableTargetsMap.computeIfAbsent(structureplacement, placement -> new ObjectArraySet()).add(holder);
            }
        }
        ArrayList<Pair> list = new ArrayList<Pair>(reachableTargetsMap.size());
        int maxSpacing = 1;
        StructureManager structuremanager = level.m_215010_();
        for (Map.Entry entry : reachableTargetsMap.entrySet()) {
            StructurePlacement placement2 = (StructurePlacement)entry.getKey();
            if (placement2 instanceof ConcentricRingsStructurePlacement) {
                double d1;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)placement2;
                Pair foundPair = chunkGenerator.m_223181_((Set)entry.getValue(), level, structuremanager, pos, newlyGenerated, concentricringsstructureplacement);
                if (foundPair == null || !((d1 = pos.m_123331_((Vec3i)foundPair.getFirst())) < maxDist)) continue;
                maxDist = d1;
                foundStructures.add((Pair<BlockPos, Holder<Structure>>)foundPair);
                continue;
            }
            if (!(placement2 instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement randomPlacement = (RandomSpreadStructurePlacement)placement2;
            list.add(Pair.of((Object)randomPlacement, (Object)((Set)entry.getValue())));
            maxSpacing = Math.max(maxSpacing, randomPlacement.m_205003_());
        }
        if (!list.isEmpty()) {
            int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
            int n = SectionPos.m_123171_((int)pos.m_123343_());
            long seed = level.m_7328_();
            StructureManager manager = level.m_215010_();
            block3: for (int k = 0; k <= maximumChunkDistance / maxSpacing; ++k) {
                int outerRing = (k + 1) * maxSpacing;
                int innerRing = k * maxSpacing;
                boolean lessPrecision = innerRing * 16 > 2000;
                TreeMap possiblePositions = new TreeMap(COMPARATOR);
                for (Pair pair : list) {
                    RandomSpreadStructurePlacement placement3 = (RandomSpreadStructurePlacement)pair.getFirst();
                    int spacing = placement3.m_205003_();
                    for (int r = innerRing; r < outerRing; r += spacing) {
                        StructureLocator.addAllPossibleFeatureChunksAtDistance(chunkX, n, r, seed, placement3, c -> {
                            List ll;
                            Vector2i v = new Vector2i(c.f_45578_ - chunkX, c.f_45579_ - chunkZ);
                            if (possiblePositions.containsKey(v)) {
                                boolean bl = true;
                            }
                            if ((ll = possiblePositions.computeIfAbsent(v, o -> new ArrayList())).contains(p)) {
                                boolean bl = true;
                            } else {
                                ll.add(p);
                            }
                        });
                    }
                }
                for (Map.Entry entry : possiblePositions.entrySet()) {
                    Vector2i vec2i = (Vector2i)entry.getKey();
                    ChunkPos chunkPos = new ChunkPos(vec2i.x() + chunkX, vec2i.y() + n);
                    List structuresThatCanSpawnAtChunkPos = (List)entry.getValue();
                    for (Pair pp : structuresThatCanSpawnAtChunkPos) {
                        foundStructures.addAll(StructureLocator.getStructuresAtChunkPos((Set)pp.getSecond(), (LevelReader)level, manager, newlyGenerated, (RandomSpreadStructurePlacement)pp.getFirst(), chunkPos));
                    }
                    if (foundStructures.size() < requiredCount) continue;
                    break block3;
                }
            }
        }
        foundStructures.sort(Comparator.comparingDouble(f -> pos.m_123331_((Vec3i)f.getFirst())));
        if (foundStructures.size() >= requiredCount) {
            return (List)Lists.partition(foundStructures, (int)requiredCount).get(0);
        }
        return foundStructures;
    }

    private static void addAllPossibleFeatureChunksAtDistance(int chunkX, int chunkZ, int radius, long seed, RandomSpreadStructurePlacement placement, Consumer<ChunkPos> positionConsumer) {
        for (int j = -radius; j <= radius; ++j) {
            boolean flag = j == -radius || j == radius;
            for (int k = -radius; k <= radius; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -radius || k == radius;
                if (!flag && !flag1) continue;
                int px = chunkX + j;
                int pz = chunkZ + k;
                ChunkPos chunkpos = placement.m_227008_(seed, px, pz);
                positionConsumer.accept(chunkpos);
            }
        }
    }

    private static Set<Pair<BlockPos, Holder<Structure>>> getStructuresAtChunkPos(Set<Holder<Structure>> targets, LevelReader level, StructureManager structureManager, boolean newChunk, RandomSpreadStructurePlacement placement, ChunkPos chunkpos) {
        HashSet<Pair<BlockPos, Holder<Structure>>> foundStructures = new HashSet<Pair<BlockPos, Holder<Structure>>>();
        for (Holder<Structure> holder : targets) {
            ChunkAccess chunkaccess;
            StructureStart structurestart;
            StructureCheckResult structurecheckresult = structureManager.m_220473_(chunkpos, (Structure)holder.m_203334_(), newChunk);
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!newChunk && structurecheckresult == StructureCheckResult.START_PRESENT) {
                foundStructures.add((Pair<BlockPos, Holder<Structure>>)Pair.of((Object)placement.m_227039_(chunkpos), holder));
            }
            if ((structurestart = structureManager.m_220512_(SectionPos.m_175562_((ChunkAccess)(chunkaccess = level.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_))), (Structure)holder.m_203334_(), (StructureAccess)chunkaccess)) == null || !structurestart.m_73603_() || newChunk && !StructureLocator.tryAddReference(structureManager, structurestart)) continue;
            foundStructures.add((Pair<BlockPos, Holder<Structure>>)Pair.of((Object)placement.m_227039_(structurestart.m_163625_()), holder));
        }
        return foundStructures;
    }

    private static boolean tryAddReference(StructureManager manager, StructureStart start) {
        if (start.m_73606_()) {
            manager.m_220484_(start);
            return true;
        }
        return false;
    }

    @Nullable
    private static Set<Pair<BlockPos, Holder<Structure>>> getNearestGeneratedStructureAtDistance(Set<Holder<Structure>> targets, LevelReader level, StructureManager featureManager, int x, int z, int distance, boolean newChunk, long seed, RandomSpreadStructurePlacement placement) {
        int i = placement.m_205003_();
        for (int j = -distance; j <= distance; ++j) {
            boolean flag = j == -distance || j == distance;
            for (int k = -distance; k <= distance; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -distance || k == distance;
                if (!flag && !flag1) continue;
                int px = x + i * j;
                int pz = z + i * k;
                ChunkPos chunkpos = placement.m_227008_(seed, px, pz);
                return StructureLocator.getStructuresAtChunkPos(targets, level, featureManager, newChunk, placement, chunkpos);
            }
        }
        return null;
    }

    @Nullable
    public BlockPos findRandomMapFeature(TagKey<Structure> tagKey, BlockPos pos, int radius, boolean unexplored, ServerLevel level) {
        if (!level.m_7654_().m_129910_().m_246337_().m_247749_()) {
            return null;
        }
        Optional optional = level.m_9598_().m_175515_(Registries.f_256944_).m_203431_(tagKey);
        if (optional.isEmpty()) {
            return null;
        }
        HolderSet.Named set = (HolderSet.Named)optional.get();
        List list = set.m_203614_().toList();
        Holder chosen = (Holder)list.get(level.f_46441_.m_188503_(list.size()));
        Pair pair = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{chosen}), pos, radius, unexplored);
        return pair != null ? (BlockPos)pair.getFirst() : null;
    }
}

