/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;

public class BlackBoardButton
implements GuiEventListener,
Renderable,
NarratableEntry {
    public final int u;
    public final int v;
    public final int x;
    public final int y;
    public static final int SIZE = 6;
    protected boolean isHovered;
    protected byte color = 0;
    protected boolean focused;
    private final IDraggable onDragged;
    private final IPressable onPress;

    public BlackBoardButton(int centerX, int centerY, int u, int v, IPressable pressedAction, IDraggable dragAction) {
        this.x = centerX - (8 - u) * 6;
        this.y = centerY - -v * 6;
        this.u = u;
        this.v = v;
        this.onPress = pressedAction;
        this.onDragged = dragAction;
    }

    public void setColor(byte color) {
        this.color = color;
    }

    public byte getColor() {
        return this.color;
    }

    public void m_88315_(GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = this.m_5953_(mouseX, mouseY);
        this.renderButton(poseStack);
    }

    public void renderButton(GuiGraphics graphics) {
        int offset = this.color > 0 ? 16 : 0;
        int rgb = BlackboardBlock.colorFromByte(this.color);
        float b = (float)FastColor.ARGB32.m_13669_((int)rgb) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)rgb) / 255.0f;
        float r = (float)FastColor.ARGB32.m_13665_((int)rgb) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        graphics.m_280163_(ModTextures.BLACKBOARD_GUI_TEXTURE, this.x, this.y, (float)(this.u + offset) * 6.0f, (float)this.v * 6.0f, 6, 6, 192, 96);
    }

    public void renderTooltip(GuiGraphics poseStack) {
        poseStack.m_280168_().m_252880_(0.0f, 0.0f, 90.0f);
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        poseStack.m_280163_(ModTextures.BLACKBOARD_GUI_TEXTURE, this.x - 1, this.y - 1, 96.0f, 0.0f, 8, 8, 192, 96);
        this.renderButton(poseStack);
    }

    public void onClick(double mouseX, double mouseY) {
        this.color = (byte)(this.color == 0 ? 1 : 0);
        this.onPress.onPress(this.u, this.v, this.color != 0);
    }

    public void onRelease(double mouseX, double mouseY) {
    }

    public void onDrag(double mouseX, double mouseY, boolean on) {
        this.color = (byte)(on ? 1 : 0);
        this.onPress.onPress(this.u, this.v, this.color != 0);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.m_5953_(mouseX, mouseY))) {
            this.playDownSound(Minecraft.m_91087_().m_91106_());
            this.onClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.onRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button)) {
            this.onDragged.onDragged(mouseX, mouseY, this.color != 0);
            return true;
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + 6) && mouseY < (double)(this.y + 6);
    }

    public void playDownSound(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public static interface IPressable {
        public void onPress(int var1, int var2, boolean var3);
    }

    public static interface IDraggable {
        public void onDragged(double var1, double var3, boolean var5);
    }
}

