/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events;

import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AshLayerBlock;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimesManager;
import net.mehvahdjukaar.supplementaries.common.entities.goals.EatFodderGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.EvokerRedMerchantWololooSpellGoal;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventOverrideHandler;
import net.mehvahdjukaar.supplementaries.common.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.FluteItem;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.items.SoapItem;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.mehvahdjukaar.supplementaries.common.misc.songs.SongsManager;
import net.mehvahdjukaar.supplementaries.common.worldgen.WaySignStructure;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSetup;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class ServerEvents {
    private static final boolean FODDER_ENABLED = CommonConfigs.Functional.FODDER_ENABLED.get();

    public static void onFireConsume(IFireConsumeBlockEvent event) {
        if (event.getState().m_60734_() instanceof IRopeConnection) {
            LevelAccessor level = event.getLevel();
            BlockPos pos = event.getPos();
            level.m_7471_(pos, false);
            if (BaseFireBlock.m_49255_((Level)((Level)level), (BlockPos)pos, (Direction)Direction.DOWN)) {
                event.setFinalState((BlockState)BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos).m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(8)));
                level.m_186460_(pos, Blocks.f_50083_, 2 + ((Level)level).f_46441_.m_188503_(1));
            }
        } else {
            AshLayerBlock.tryConvertToAsh(event);
        }
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.m_5833_()) {
            return InteractEventOverrideHandler.onItemUsedOnBlock(player, level, player.m_21120_(hand), hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onRightClickBlockHP(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.m_5833_()) {
            return InteractEventOverrideHandler.onItemUsedOnBlockHP(player, level, player.m_21120_(hand), hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> onUseItem(Player player, Level level, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_5833_()) {
            return InteractEventOverrideHandler.onItemUse(player, level, hand, stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
    }

    public static InteractionResult onRightClickEntity(Player player, Level level, InteractionHand hand, Entity entity, @Nullable EntityHitResult entityHitResult) {
        InteractionResult res;
        AbstractMobContainerItem containerItem;
        if (player.m_5833_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof FluteItem ? FluteItem.interactWithPet(stack, player, entity, hand) : (item instanceof AbstractMobContainerItem ? !(containerItem = (AbstractMobContainerItem)item).isFull(stack) && (res = containerItem.doInteract(stack, player, entity, hand)).m_19077_() : item == ModRegistry.SOAP.get() && SoapItem.interactWithEntity(stack, player, entity, hand))) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void onDataSyncToPlayer(ServerPlayer player, boolean joined) {
        SongsManager.sendDataToClient(player);
        CapturedMobHandler.sendDataToClient(player);
        GlobeData.sendDataToClient(player);
        HourglassTimesManager.sendDataToClient(player);
    }

    public static void onCommonTagUpdate(RegistryAccess registryAccess, boolean client) {
        ModSetup.tagDependantSetup(registryAccess);
        if (!client) {
            ModDamageSources.reload(registryAccess);
            WaySignStructure.recomputeValidStructureCache(registryAccess);
        }
    }

    public static void onEntityLoad(Entity entity, ServerLevel serverLevel) {
        if (FODDER_ENABLED && entity instanceof Animal) {
            Animal animal = (Animal)entity;
            EntityType type = entity.m_6095_();
            if (type.m_204039_(ModTags.EATS_FODDER)) {
                animal.f_21345_.m_25352_(3, (Goal)new EatFodderGoal(animal, 1.0, 8, 2, 30));
            }
            return;
        }
        if (entity.m_6095_() == EntityType.f_20568_) {
            ((Evoker)entity).f_21345_.m_25352_(6, (Goal)new EvokerRedMerchantWololooSpellGoal((Evoker)entity));
        }
    }

    public static boolean onItemPickup(ItemEntity itemEntity, Player player) {
        ItemStack stack = itemEntity.m_32055_();
        if (!itemEntity.m_32063_() && CommonConfigs.Tools.QUIVER_PICKUP.get().booleanValue() && stack.m_41720_() instanceof ArrowItem && (itemEntity.m_19749_() == null || SuppPlatformStuff.getItemLifeSpawn(itemEntity) - itemEntity.m_32059_() <= 200 || itemEntity.m_19749_().equals((Object)player.m_20148_()))) {
            ItemStack old = stack.m_41777_();
            if (ServerEvents.takeArrow((Entity)itemEntity, player, stack)) {
                SuppPlatformStuff.onItemPickup(player, itemEntity, old);
                player.m_21053_(itemEntity);
                player.m_6278_(Stats.f_12984_.m_12902_((Object)stack.m_41720_()), old.m_41613_() - stack.m_41613_());
                return true;
            }
        }
        return false;
    }

    public static boolean onArrowPickup(AbstractArrow arrow, Player player, Supplier<ItemStack> pickup) {
        if (CommonConfigs.Tools.QUIVER_PICKUP.get().booleanValue()) {
            ItemStack stack = pickup.get();
            return ServerEvents.takeArrow((Entity)arrow, player, stack);
        }
        return false;
    }

    private static boolean takeArrow(Entity itemEntity, Player player, ItemStack stack) {
        int newCount;
        ItemStack copy;
        int count;
        QuiverItem.Data data;
        ItemStack quiverItem = QuiverItem.getQuiver((LivingEntity)player);
        if (!quiverItem.m_41619_() && (data = QuiverItem.getQuiverData(quiverItem)) != null && (count = (copy = stack.m_41777_()).m_41613_()) != (newCount = data.tryAdding(copy, true).m_41613_())) {
            player.m_7938_(itemEntity, count);
            stack.m_41764_(newCount);
            if (stack.m_41619_()) {
                itemEntity.m_146870_();
            }
            return true;
        }
        return false;
    }
}

