/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc;

import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RopeHelper {
    public static boolean addRopeDown(BlockPos pos, Level level, @Nullable Player player, InteractionHand hand, Block ropeBlock) {
        return RopeHelper.addRope(pos, level, player, hand, ropeBlock, Direction.DOWN, true, Integer.MAX_VALUE);
    }

    public static boolean addRope(BlockPos pos, Level level, @Nullable Player player, InteractionHand hand, Block ropeBlock, Direction moveDir, boolean canPush, int maxDist) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveDir)) {
            return RopeHelper.addRope(pos.m_121945_(moveDir), level, player, hand, ropeBlock, moveDir, canPush, maxDist);
        }
        if (state.m_60713_(ModRegistry.PULLEY_BLOCK.get()) && (blockEntity = level.m_7702_(pos)) instanceof PulleyBlockTile) {
            PulleyBlockTile te = (PulleyBlockTile)blockEntity;
            return te.rotateIndirect(player, hand, ropeBlock, moveDir, false);
        }
        return RopeHelper.tryPlaceAndMove(player, hand, level, pos, ropeBlock, moveDir, canPush);
    }

    public static boolean isCorrectRope(Block ropeBlock, BlockState state, Direction direction) {
        if (state.m_60734_() instanceof ChainBlock && state.m_61143_((Property)ChainBlock.f_55923_) != direction.m_122434_()) {
            return false;
        }
        return ropeBlock == state.m_60734_();
    }

    public static boolean tryPlaceAndMove(@Nullable Player player, InteractionHand hand, Level world, BlockPos pos, Block ropeBlock, Direction moveDir, boolean canPush) {
        BlockState state;
        ItemStack stack = new ItemStack((ItemLike)ropeBlock);
        BlockPlaceContext context = new BlockPlaceContext(world, player, hand, stack, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), moveDir.m_122424_(), pos, false));
        if (!context.m_7059_()) {
            BlockPos downPos = pos.m_121945_(moveDir);
            if (!(canPush && world.m_8055_(downPos).m_247087_() && RopeHelper.tryMove(pos, downPos, world))) {
                return false;
            }
            context = new BlockPlaceContext(world, player, hand, stack, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), moveDir.m_122424_(), pos, false));
        }
        if ((state = ItemsUtil.getPlacementState(context, ropeBlock)) == null) {
            return false;
        }
        if (state == world.m_8055_(context.m_8083_())) {
            return false;
        }
        if (world.m_7731_(context.m_8083_(), state, 11)) {
            BlockState placedState;
            Block block;
            if (player != null && (block = (placedState = world.m_8055_(context.m_8083_())).m_60734_()) == state.m_60734_()) {
                block.m_6402_(world, context.m_8083_(), placedState, (LivingEntity)player, stack);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10591_.m_285767_(serverPlayer, context.m_8083_(), stack);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isBlockMovable(BlockState state, Level level, BlockPos pos) {
        if (state.m_60734_() instanceof PulleyBlock) {
            return false;
        }
        return !state.m_60795_() && !state.m_60713_(Blocks.f_50080_) && !state.m_60713_(Blocks.f_50085_) && !state.m_60713_(Blocks.f_50723_) && !state.m_60713_(Blocks.f_50724_) && state.m_60800_((BlockGetter)level, pos) != -1.0f;
    }

    public static boolean removeRopeDown(BlockPos pos, Level level, Block ropeBlock) {
        return RopeHelper.removeRope(pos, level, ropeBlock, Direction.DOWN, Integer.MAX_VALUE);
    }

    public static boolean removeRope(BlockPos pos, Level level, Block ropeBlock, Direction moveUpDir, int maxDist) {
        PulleyBlockTile te;
        BlockEntity blockEntity;
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        BlockState state = level.m_8055_(pos);
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveUpDir)) {
            return RopeHelper.removeRope(pos.m_121945_(moveUpDir), level, ropeBlock, moveUpDir, maxDist);
        }
        if (state.m_60713_(ModRegistry.PULLEY_BLOCK.get()) && (blockEntity = level.m_7702_(pos)) instanceof PulleyBlockTile && !(te = (PulleyBlockTile)blockEntity).m_7983_()) {
            return te.rotateIndirect(null, InteractionHand.MAIN_HAND, ropeBlock, moveUpDir, true);
        }
        BlockPos up = pos.m_121945_(moveUpDir.m_122424_());
        if (level.m_8055_(up).m_60734_() != ropeBlock) {
            return false;
        }
        FluidState fromFluid = level.m_6425_(up);
        boolean water = fromFluid.m_76152_() == Fluids.f_76193_ && fromFluid.m_76170_();
        level.m_46597_(up, water ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
        RopeHelper.tryMove(pos, up, level);
        return true;
    }

    private static boolean tryMove(BlockPos fromPos, BlockPos toPos, Level world) {
        if (toPos.m_123342_() < world.m_141937_() || toPos.m_123342_() > world.m_151558_()) {
            return false;
        }
        BlockState state = world.m_8055_(fromPos);
        PushReaction push = state.m_60811_();
        if (RopeHelper.isBlockMovable(state, world, fromPos) && ((push == PushReaction.NORMAL || toPos.m_123342_() < fromPos.m_123342_() && push == PushReaction.PUSH_ONLY) && state.m_60710_((LevelReader)world, toPos) || state.m_204336_(ModTags.ROPE_HANG_TAG))) {
            FluidState fromFluid;
            Fluid fluidState;
            BlockEntity tile = world.m_7702_(fromPos);
            if (tile != null) {
                if (CompatHandler.QUARK && !QuarkCompat.canMoveBlockEntity(state)) {
                    return false;
                }
                tile.m_7651_();
            }
            boolean waterFluid = (fluidState = world.m_6425_(toPos).m_76152_()) == Fluids.f_76193_;
            boolean canHoldWater = false;
            if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                canHoldWater = state.m_204336_(ModTags.WATER_HOLDER);
                if (!canHoldWater) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(waterFluid));
                }
            } else if (state.m_60734_() instanceof AbstractCauldronBlock) {
                if (waterFluid && state.m_60713_(Blocks.f_50256_) || state.m_60713_(Blocks.f_152476_)) {
                    state = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
                }
                if (fluidState == Fluids.f_76195_ && state.m_60713_(Blocks.f_50256_) || state.m_60713_(Blocks.f_152477_)) {
                    state = (BlockState)Blocks.f_152477_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
                }
            }
            boolean leaveWater = (fromFluid = world.m_6425_(fromPos)).m_76152_() == Fluids.f_76193_ && fromFluid.m_76170_() && !canHoldWater;
            world.m_46597_(fromPos, leaveWater ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_());
            BlockState newState = Block.m_49931_((BlockState)state, (LevelAccessor)world, (BlockPos)toPos);
            world.m_46597_(toPos, newState);
            if (tile != null) {
                CompoundTag tag = tile.m_187482_();
                BlockEntity te = world.m_7702_(toPos);
                if (te != null) {
                    te.m_142466_(tag);
                }
            }
            world.m_46586_(toPos, state.m_60734_(), toPos);
            return true;
        }
        return false;
    }
}

