/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import com.mojang.blaze3d.platform.Lighting;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.BlackBoardButton;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetBlackboardPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BlackBoardScreen
extends Screen {
    private static final MutableComponent CLEAR = Component.m_237115_((String)"gui.supplementaries.blackboard.clear");
    private static final MutableComponent EDIT = Component.m_237115_((String)"gui.supplementaries.blackboard.edit");
    private final BlackboardBlockTile tile;
    private final BlackBoardButton[][] buttons = new BlackBoardButton[16][16];

    private BlackBoardScreen(BlackboardBlockTile teBoard) {
        super((Component)EDIT);
        this.tile = teBoard;
    }

    public static void open(BlackboardBlockTile sign) {
        Minecraft.m_91087_().m_91152_((Screen)new BlackBoardScreen(sign));
    }

    public void m_86600_() {
        if (!this.isValid()) {
            this.close();
        }
    }

    private boolean isValid() {
        return this.f_96541_ != null && this.f_96541_.f_91074_ != null && !this.tile.m_58901_() && !this.tile.playerIsTooFarAwayToEdit(this.tile.m_58904_(), this.tile.m_58899_(), this.f_96541_.f_91074_.m_20148_());
    }

    public void m_7379_() {
        this.close();
    }

    public void m_7861_() {
        byte[][] pixels = new byte[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].getColor();
            }
        }
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundSetBlackboardPacket(this.tile.m_58899_(), pixels));
    }

    private void close() {
        this.tile.m_6596_();
        this.f_96541_.m_91152_(null);
    }

    public void setPixel(int x, int y, boolean on) {
        this.tile.setPixel(x, y, (byte)(on ? 1 : 0));
    }

    public void dragButtons(double mx, double my, boolean on) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (!this.buttons[xx][yy].m_5953_(mx, my)) continue;
                this.buttons[xx][yy].onDrag(mx, my, on);
            }
        }
    }

    private void clear() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.setPixel(xx, yy, false);
                this.buttons[xx][yy].setColor((byte)0);
            }
        }
    }

    protected void m_7856_() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy] = new BlackBoardButton(this.f_96543_ / 2, 65, xx, yy, this::setPixel, this::dragButtons);
                this.m_142416_(this.buttons[xx][yy]);
                this.buttons[xx][yy].setColor(this.tile.getPixel(xx, yy));
            }
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CLEAR, b -> this.clear()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 96, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.close()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ / 4 + 120, 96, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Lighting.m_84930_();
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        graphics.m_280168_().m_85836_();
        int ut = -1;
        int vt = -1;
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (this.buttons[xx][yy].isHovered()) {
                    ut = xx;
                    vt = yy;
                }
                this.buttons[xx][yy].m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
        }
        if (ut != -1) {
            this.buttons[ut][vt].renderTooltip(graphics);
        }
        graphics.m_280168_().m_85849_();
        Lighting.m_84931_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }
}

