/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.worldgen.RoadSignFeature;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;

public class BlockGeneratorBlockTile
extends BlockEntity {
    private static final ExecutorService EXECUTORS = Executors.newCachedThreadPool();
    private final AtomicReference<List<Pair<BlockPos, Holder<Structure>>>> threadResult = new AtomicReference<Object>(null);
    private boolean firstTick = true;
    private RoadSignFeature.Config config = null;

    public BlockGeneratorBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BLOCK_GENERATOR_TILE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockGeneratorBlockTile tile) {
        if (tile.firstTick) {
            tile.firstTick = false;
            ServerLevel serverLevel = (ServerLevel)level;
            EXECUTORS.submit(() -> {
                try {
                    tile.threadResult.set(StructureLocator.findNearestMapFeatures(serverLevel, ModTags.WAY_SIGN_DESTINATIONS, pos, 250, false, 2, false));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        try {
            List<Pair<BlockPos, Holder<Structure>>> result = tile.threadResult.get();
            if (result != null) {
                RoadSignFeature.applyPostProcess(tile.config, (ServerLevel)level, pos, result);
            }
        }
        catch (Exception e) {
            level.m_7471_(pos, false);
            Supplementaries.LOGGER.error("Failed to generate road sign at " + pos + ": " + e);
        }
    }

    public void setConfig(RoadSignFeature.Config c) {
        this.config = c;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.config != null) {
            tag.m_128365_("config", (Tag)RoadSignFeature.Config.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.config).getOrThrow(false, s -> {}));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("config")) {
            this.config = (RoadSignFeature.Config)((Pair)RoadSignFeature.Config.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("config")).getOrThrow(true, s -> {})).getFirst();
        }
    }
}

