/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GobletBlockTile
extends BlockEntity
implements ISoftFluidTankProvider,
IOwnerProtected,
IExtraModelDataProvider {
    private UUID owner = null;
    public final SoftFluidTank fluidHolder = SoftFluidTank.create((int)1);
    public static final ModelDataKey<SoftFluid> FLUID_ID = ModBlockProperties.FLUID;

    public GobletBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.GOBLET_TILE.get(), pos, state);
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(FLUID_ID, (Object)this.getSoftFluidTank().getFluid()).build();
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void m_6596_() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        int light = this.fluidHolder.getFluid().getLuminosity();
        if (light != (Integer)this.m_58900_().m_61143_((Property)ModBlockProperties.LIGHT_LEVEL_0_15)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        super.m_6596_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean handleInteraction(Player player, InteractionHand hand) {
        if (this.fluidHolder.interactWithPlayer(player, hand, this.f_58857_, this.f_58858_)) {
            return true;
        }
        if (!player.m_6144_() && CommonConfigs.Building.GOBLET_DRINK.get().booleanValue()) {
            boolean b = this.fluidHolder.tryDrinkUpFluid(player, this.f_58857_);
            if (b && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Advancement advancement = this.f_58857_.m_7654_().m_129889_().m_136041_(new ResourceLocation("supplementaries:nether/goblet"));
                if (advancement != null && !serverPlayer.m_8960_().m_135996_(advancement).m_8193_()) {
                    serverPlayer.m_8960_().m_135988_(advancement, "unlock");
                }
            }
            return b;
        }
        return false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        try {
            this.fluidHolder.load(compound);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("Failed to load fluid container at {}:", (Object)this.m_58899_(), (Object)e);
        }
        this.loadOwner(compound);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.requestModelReload();
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        try {
            this.fluidHolder.save(tag);
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("Failed to save fluid container at {}:", (Object)this.m_58899_(), (Object)e);
        }
        this.saveOwner(tag);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidHolder;
    }
}

