/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.PendulumAnimation;
import net.mehvahdjukaar.supplementaries.common.block.SwingAnimation;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Deprecated(forRemoval=true)
public class HangingSignTileExtension {
    @Nullable
    private ModBlockProperties.PostType leftAttachment = null;
    @Nullable
    private ModBlockProperties.PostType rightAttachment = null;
    private final boolean isCeiling;
    private boolean canSwing = true;
    public final SwingAnimation animation = PlatHelper.getPhysicalSide().isClient() ? new PendulumAnimation(ClientConfigs.Blocks.HANGING_SIGN_CONFIG, this::getRotationAxis) : null;

    public HangingSignTileExtension(BlockState state) {
        this.isCeiling = state.m_60734_() instanceof CeilingHangingSignBlock;
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (!this.canSwing) {
            this.animation.reset();
        } else {
            this.animation.tick(level, pos, state);
        }
    }

    private Vector3f getRotationAxis(BlockState state) {
        return state.m_61138_((Property)WallHangingSignBlock.f_244390_) ? ((Direction)state.m_61143_((Property)WallHangingSignBlock.f_244390_)).m_122427_().m_253071_() : new Vector3f(0.0f, 0.0f, 1.0f).rotateY((float)Math.PI / 180 * (90.0f + RotationSegment.m_245107_((int)((Integer)state.m_61143_((Property)CeilingHangingSignBlock.f_244083_)))));
    }

    public ModBlockProperties.PostType getRightAttachment() {
        return this.rightAttachment;
    }

    public ModBlockProperties.PostType getLeftAttachment() {
        return this.leftAttachment;
    }

    public void saveAdditional(CompoundTag tag) {
        if (!this.isCeiling) {
            if (this.leftAttachment != null) {
                tag.m_128344_("left_attachment", (byte)this.leftAttachment.ordinal());
            }
            if (this.rightAttachment != null) {
                tag.m_128344_("right_attachment", (byte)this.rightAttachment.ordinal());
            }
        }
        if (!this.canSwing) {
            tag.m_128379_("can_swing", false);
        }
    }

    public void load(CompoundTag tag) {
        if (!this.isCeiling) {
            if (tag.m_128441_("left_attachment")) {
                this.leftAttachment = ModBlockProperties.PostType.values()[tag.m_128445_("left_attachment")];
            }
            if (tag.m_128441_("right_attachment")) {
                this.rightAttachment = ModBlockProperties.PostType.values()[tag.m_128445_("right_attachment")];
            }
        }
        if (tag.m_128441_("can_swing")) {
            this.canSwing = tag.m_128471_("can_swing");
        }
    }

    public void updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!this.isCeiling) {
            Direction selfFacing = (Direction)state.m_61143_((Property)WallHangingSignBlock.f_244390_);
            if (direction == selfFacing.m_122427_()) {
                this.rightAttachment = ModBlockProperties.PostType.get(neighborState, true);
                if (level instanceof Level) {
                    Level l = (Level)level;
                    l.m_7260_(pos, state, state, 2);
                }
            } else if (direction == selfFacing.m_122428_()) {
                this.leftAttachment = ModBlockProperties.PostType.get(neighborState, true);
                if (level instanceof Level) {
                    Level l = (Level)level;
                    l.m_7260_(pos, state, state, 2);
                }
            }
        }
        if (direction == Direction.DOWN) {
            this.canSwing = this.isCeiling && (Boolean)state.m_61143_((Property)CeilingHangingSignBlock.f_243835_) != false || !IRopeConnection.canConnectDown(neighborState);
        }
    }

    public void updateAttachments(Level level, BlockPos pos, BlockState state) {
        if (!this.isCeiling) {
            Direction selfFacing = (Direction)state.m_61143_((Property)WallHangingSignBlock.f_244390_);
            this.rightAttachment = ModBlockProperties.PostType.get(level.m_8055_(pos.m_121945_(selfFacing.m_122427_())), true);
            this.leftAttachment = ModBlockProperties.PostType.get(level.m_8055_(pos.m_121945_(selfFacing.m_122428_())), true);
        }
        BlockState below = level.m_8055_(pos.m_7495_());
        this.canSwing = this.isCeiling && (Boolean)state.m_61143_((Property)CeilingHangingSignBlock.f_243835_) != false || !IRopeConnection.canConnectDown(below);
    }

    public boolean canSwing() {
        return this.canSwing;
    }
}

