/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.WeatheredMap;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EmptyMapItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class SliceMapItem
extends EmptyMapItem {
    private static final String DEPTH_LOCK_KEY = "depth_lock";
    public static final CustomMapData.Type<DepthMapData> DEPTH_DATA_KEY = MapDataRegistry.registerCustomMapSavedData((ResourceLocation)Supplementaries.res("depth_lock"), DepthMapData::new);

    public SliceMapItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12493_, player.m_5720_(), 1.0f, 1.0f);
        int slice = (int)player.m_20186_() + 1;
        ItemStack itemStack2 = SliceMapItem.createSliced(level, player.m_146903_(), player.m_146907_(), (byte)0, true, false, slice);
        if (itemStack.m_41619_()) {
            return InteractionResultHolder.m_19096_((Object)itemStack2);
        }
        if (!player.m_150109_().m_36054_(itemStack2.m_41777_())) {
            player.m_36176_(itemStack2, false);
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public static ItemStack createSliced(Level level, int x, int z, byte scale, boolean trackingPosition, boolean unlimitedTracking, int slice) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42573_);
        MapItemSavedData data = MapItemSavedData.m_164780_((double)x, (double)z, (byte)scale, (boolean)trackingPosition, (boolean)unlimitedTracking, (ResourceKey)level.m_46472_());
        DepthMapData instance = (DepthMapData)DEPTH_DATA_KEY.getOrCreate(data, DepthMapData::new);
        instance.set(slice);
        instance.setDirty(data);
        int mapId = level.m_7354_();
        level.m_142325_(MapItem.m_42848_((int)mapId), data);
        itemStack.m_41784_().m_128405_("map", mapId);
        return itemStack;
    }

    public static void init() {
    }

    public static int getMapHeight(MapItemSavedData data) {
        DepthMapData depth = (DepthMapData)DEPTH_DATA_KEY.get(data);
        return depth == null ? Integer.MAX_VALUE : depth.height;
    }

    public static MapColor getCutoffColor(BlockPos pos, BlockGetter level) {
        return (pos.m_123341_() + pos.m_123343_()) % 2 == 0 ? MapColor.f_283808_ : WeatheredMap.ANTIQUE_LIGHT;
    }

    public static double getRangeMultiplier() {
        return CommonConfigs.Tools.SLICE_MAP_RANGE.get();
    }

    public static boolean canPlayerSee(int targetY, Entity entity) {
        Level level = entity.m_9236_();
        int py = entity.m_146904_();
        RandomSource rand = level.m_213780_();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int spread = 3;
        p.m_122190_((Vec3i)entity.m_20183_().m_7918_(rand.m_188503_(spread) - rand.m_188503_(spread), 0, rand.m_188503_(spread) - rand.m_188503_(spread)));
        int direction = Integer.compare(targetY, py);
        while (p.m_123342_() != targetY) {
            if (level.m_8055_((BlockPos)p).m_284242_((BlockGetter)level, (BlockPos)p) != MapColor.f_283808_) {
                return false;
            }
            p.m_142448_(p.m_123342_() + direction);
        }
        return true;
    }

    private static class DepthMapData
    implements CustomMapData {
        private int height;

        public DepthMapData(CompoundTag tag) {
            this.height = tag.m_128441_(SliceMapItem.DEPTH_LOCK_KEY) ? tag.m_128451_(SliceMapItem.DEPTH_LOCK_KEY) : Integer.MAX_VALUE;
        }

        public DepthMapData() {
        }

        public CustomMapData.Type<DepthMapData> getType() {
            return DEPTH_DATA_KEY;
        }

        public void save(CompoundTag tag) {
            if (this.height != Integer.MAX_VALUE) {
                tag.m_128405_(SliceMapItem.DEPTH_LOCK_KEY, this.height);
            }
        }

        @Nullable
        public Component onItemTooltip(MapItemSavedData data, ItemStack stack) {
            if (this.height == Integer.MAX_VALUE) {
                return null;
            }
            return Component.m_237110_((String)"filled_map.sliced.tooltip", (Object[])new Object[]{this.height}).m_130940_(ChatFormatting.GRAY);
        }

        public void set(int slice) {
            this.height = slice;
        }
    }
}

